job {
  name 'release-consul-ec2-cleanup'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'release/consul-ec2-cleanup', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'
    saveDeployArtifact 'release/consul-ec2-cleanup', '.manta/'
    shell 'update-deployed-version -repo release/consul-ec2-cleanup'
  }
}

job {
  name 'release-consul-ec2-cleanup-pop'
  parameters {
		stringParam 'GIT_COMMIT'
	}
  steps {
    downloadDeployArtifact 'release/consul-ec2-cleanup'
    shell './consul-ec2-cleanup'
  }
  wrappers {
		preBuildCleanup()
		timestamps()
	}
}
