package main

import (
	"fmt"
	"log"
	"regexp"

	"github.com/hashicorp/consul/api"
)

var (
	ipNodeName = regexp.MustCompile(`ip-\d+-\d+-\d+-\d+.*`)
)

func main() {
	client, err := api.NewClient(api.DefaultConfig())
	if err != nil {
		log.Fatal(err)
	}

	res, _, err := client.Catalog().Nodes(nil)
	if err != nil {
		log.Fatal(err)
	}

	for _, r := range res {
		if ipNodeName.MatchString(r.Node) {
			deregisterNode(client, r.Node)
		} else {
			fmt.Printf("Skipping non-ip host: %q\n", r.Node)
		}
	}

}

func deregisterNode(client *api.Client, node string) error {
	health, _, err := client.Health().Node(node, nil)
	if err != nil {
		return err
	}

	for _, hc := range health {
		if hc.Name == "serfHealth" && hc.Status == "passing" {
			fmt.Printf("Skipping passing host: %q\n", node)
			return nil
		}
	}

	fmt.Printf("Deregistring: %q\n", node)
	return client.Agent().ForceLeave(node)
}
