job {
	name 'release-consul-manta'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/consul-manta', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
  throttleConcurrentBuilds {
      maxPerNode 2
  }
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -e BINARY_INSTALL=false -v -proxy -f xenial_manta.json'
		shell 'manta -e BINARY_INSTALL=false -v -proxy -f trusty_manta.json'
		shell 'manta -e BINARY_INSTALL=false -v -proxy -f precise_manta.json'
		saveDeployArtifact 'release/consul-manta', '.manta'
	}
}

job {
	name 'release-consul-manta-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/consul-manta'
		uploadDeb 'consul_precise.deb', 'precise'
		uploadDeb 'consul_trusty.deb', 'trusty'
		uploadDeb 'consul_xenial.deb', 'xenial'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
    }
	}
}
