#!/bin/sh
set -e
set -x

codename=`lsb_release -c -s`

# Cleanup
cd /tmp/mount
find -name '*.deb' -delete

export GOPATH=/go:/tmp/mount/Godeps/_workspace

# Copy files for deb
mkdir -p ./deb/usr/bin
mkdir -p ./deb/usr/share/consul/dist

CONSUL_VERSION="0.6.3"
CONSUL_BIN_SHA="b0532c61fec4a4f6d130c893fd8954ec007a6ad93effbe283a39224ed237e250"
CONSUL_UI_SHA="93bbb300cacfe8de90fb3bd5ede7d37ae6ce014898edc520b9c96a676b2bbb72"
PACKAGE_VERSION="5"
BINARY_INSTALL=${BINARY_INSTALL:-true}

if [ "${BINARY_INSTALL}" = "true" ] ; then # Install from pre made binary
  wget --no-check-certificate -O /tmp/consul.zip https://releases.hashicorp.com/consul/${CONSUL_VERSION}/consul_${CONSUL_VERSION}_linux_amd64.zip
  wget --no-check-certificate -O /tmp/consul_web_ui.zip https://releases.hashicorp.com/consul/${CONSUL_VERSION}/consul_${CONSUL_VERSION}_web_ui.zip
  echo "${CONSUL_BIN_SHA}  /tmp/consul.zip" | sha256sum --check
  echo "${CONSUL_UI_SHA}  /tmp/consul_web_ui.zip" | sha256sum --check
  unzip -d ./deb/usr/bin /tmp/consul.zip
  unzip -d ./deb/usr/share/consul/dist /tmp/consul_web_ui.zip
else # Build Consul
  patch -f -p1 -u --verbose < patches/consul_6.3.1-serfconfigmod.patch
  grep MaxQueueDepth Godeps/_workspace/src/github.com/hashicorp/serf/serf/config.go
  go build  -o /tmp/mount/deb/usr/bin/consul github.com/hashicorp/consul
  if [ ! "$codename" = "lucid" ] ; then
    # Build UI
    cd /tmp/mount/Godeps/_workspace/src/github.com/hashicorp/consul/ui
    sed -i 's!https!http!' Gemfile
    bundle install
    make dist
    find / | grep dist | grep consul
    cd /tmp/mount
    cp -av /tmp/mount/Godeps/_workspace/src/github.com/hashicorp/consul/ui/* ./deb/usr/share/consul/dist
  fi
fi

# Make deb
sed -i "s/Version:\(.*\)$/Version: ${CONSUL_VERSION}.${PACKAGE_VERSION}+${codename}/" ./deb/DEBIAN/control
dpkg-deb -Z gzip -b ./deb ./extract/consul_${codename}.deb
echo "${CONSUL_VERSION}.${PACKAGE_VERSION}" > ./extract/version
