#!/bin/sh
set -x
set -e

# We need lsb_release to know the codename.
apt-get update
apt-get -y install lsb-release

codename=`lsb_release -c -s`

locale-gen en_US.UTF-8
dpkg-reconfigure locales

cat > /etc/gemrc <<eos
:verbose: true
:update_sources: true
gem: --no-rdoc --no-ri
install: --no-rdoc --no-ri --no-http-proxy
update:  --no-rdoc --no-ri --no-http-proxy
eos

git_package="git"

if [ "$codename" = "lucid" ]
then
  git_package="git-core"
fi

# Consul requirements
apt-get update && apt-get -y install wget mercurial gcc make $git_package

apt-get -y install zip unzip
if [ "$codename" = "xenial" ] ; then
  apt-get -y install wget mercurial g++ rubygems ruby ruby-dev openssl
  gem install bundler
elif [ ! "$codename" = "lucid" ] ; then
  # Ruby requirements
  apt-get -y install wget mercurial g++ rubygems1.9.1 ruby1.9.1 ruby1.9.1-dev libopenssl-ruby1.9.1 openssl
  gem install bundler
fi


goTar="go1.7.4.linux-amd64.tar.gz"
goSha="47fda42e46b4c3ec93fa5d4d4cc6a748aa3f9411a2a2b7e08e3a6d80d753ec8b"

# '--no-check-certificate' is because lucid's wget is apparently not compatible
# with google's certs anymore.
wget --no-check-certificate https://storage.googleapis.com/golang/${goTar}

echo "${goSha}  ${goTar}" | sha256sum --check
tar -C /usr/local -xzf ${goTar}
go get -v github.com/kr/godep
