job {
	name 'release-consul-template-manta'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/consul-template-manta', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
  throttleConcurrentBuilds {
      maxPerNode 2
  }
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v'
		saveDeployArtifact 'release/consul-template-manta', '.manta'
	}
}

job {
	name 'release-consul-template-manta-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/consul-template-manta'
		uploadDeb 'consul-template.deb'
	}
	wrappers {
		preBuildCleanup()
		timestamps()
    credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
    }
	}
}
