courier
=======

[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=release-courier)](https://jenkins-og.xarth.tv/job/release-courier/)

Fetches and installs twitch-written applications. Aims to replace capistrano/fabric/etc.

Courier will install applications both locally or remotely.  Using the ```deploy``` subcommand enables the remote mode, which uses ```--hosts``` or ```$HOSTS``` to target machines over ssh. When using `deploy` to deploy via [clean-deploy](https://deploy.xarth.tv/), it is recommended that you do not pass `--hosts` and let courier read hosts from the environment. This is because large host deployments are split over multiple variables(HOSTS, HOSTS2, HOSTS3, ...) and `courier` will aggregate these variables for you.

Courier uses ```--environment``` or ```$ENVIRONMENT``` to query consul for the appropriate version of the package to download and install. This assumes your jenkins deploy job is updating this value in consul before running courier.

The following are examples of running in local mode, and also work when using remote mode.

## Development

To simplify the development workflow, it's easiest to just run manta (just as Jenkins does) to build courier.

1. Install [Docker](https://www.docker.com/community-edition) and [Manta](https://twitchtv.atlassian.net/wiki/display/ENG/Manta).  *NOTE*: Manta currently has issues on OS X due to [$SSH_AUTH_SOCK is not being forwarded to docker](https://github.com/docker/for-mac/issues/410).
2. Make your code changes.
3. Run `manta -v` to build and test your code

When ready to push code to production:
1. Install [bumpversion][bumpversion]: ```pip install --upgrade bumpversion```
2. Do a PR and get your code merged to master
3. Use ```bumpversion --verbose <patch|minor|major>``` to upgrade the version in code and on tag
4. git push --tags

## Installing courier

### OSX

```go get code.justin.tv/release/courier/cmd/courier```

### Ubuntu

```apt-get install courier```

## Installing a project

### tar

```
> courier tar install -h

NAME:
   install - (Local) Install tar to DIR/releases/SHA and point to it with 'current' symlink

USAGE:
   command install [command options] [arguments...]

OPTIONS:
   --consul-host 'localhost:8500'
   --skadi-host 'https://deploy.xarth.tv'
   --hosts                                                      comma-separated list of target hosts [$HOSTS]
   --environment                                                environment to use when looking up app version in consul [$ENVIRONMENT]
   --repo                                                       repository fullname. Format: owner/repo
   --short-circuit                                              Fail the deploy if any remote nodes return an error
   --skip-symlink                                               Do not update the current symlink
   --skip-restart                                               Skip restarting the application
   --dir                                                        directory containing releases and current symlink (tar only)
   --target                                                     name to use for the target name in the releases dir (tar only)
   --sha                                                        override the sha to deploy rather than querying latest from consul (tar only)
   --config-path                                                override the default courier.conf (/etc/courier.conf) filepath
   --retries '3'                                                Number of times we try to performan an operation on remote nodes (default: 3)
   --ssh-dial-timeout                                           SSH dial connection timeout in seconds (default: 20)
   --user 'jtv'                                                 The username we will run code under (default: jtv)

```

### pkg

Note that for packages in general, they are installed to fixed absolute locations, and are responsible for symlinking and restarting themself after installation. Therefore --dir, --target, --skip-symlink and --skip-restart are not supported. --config-path is not supported as there are no courier.conf values to be read.

Does not support the `status` or `restart` subcommand. Supports a `remove` subcommand, which removes an installed package (primarily to reduce side-effects of integration tests).

```
> courier pkg install -h

NAME:
   courier pkg install - (Local) Install package

USAGE:
   courier pkg install [command options] [arguments...]

OPTIONS:
   --consul-host value       (default: "localhost:8500")
   --skadi-host value        (default: "https://deploy.xarth.tv")
   --hosts value             comma-separated list of target hosts
   --environment value       environment to use when looking up app version in consul [$ENVIRONMENT]
   --repo value              repository fullname. Format: owner/repo
   --short-circuit           Fail the deploy if any remote nodes return an error
   --rollback-sha value      override the sha to rollback rather than querying consul (tar+pkg only)
   --sha value               override the sha to deploy rather than querying latest from consul (tar+pkg only)
   --retries value           Number of times we try to performan an operation on remote nodes (default: 3) (default: 3)
   --user value              The username we will run code under (default: jtv)
   --ssh-dial-timeout value  SSH dial connection timeout in seconds (default: 20) (default: 20)
```

## Restarting a project

### tar (Not implemented)
### pkg (Not implemented, and not part of courier's responsibilities)

## Links

[bumpversion]: https://pypi.python.org/pypi/bumpversion


