Configuration
===

Configuration is read by default from `/etc/courier.conf`. An alternative configuration file can be
specified in the `--config-path` flag. The configuration file format is a json object with the
keys detailed below.

Keys
---


  * `consul_host`

    The hostname of the endpoint to use for Consul HTTP API calls. This can be overridden with the 
`--consul-host` flag.

  * `build_retention`

    The number of previous installations 

  * `user`

    The user to assume when running courier remotely (deploy/rollback). This can be overriden with
the `--user` flag.

  * `max_transfer_rate`

    The maximum rate in bytes/second at which to download artifacts. If unspecified, the download
    rate will be unrestricted.

  * `downloader`

    The type of downloader to use when retrieving artifacts. Valid values are "http", "s3". Defaults to "s3".

### HTTP Downloader

The following keys are used when the downloader type is "http".

  * `http_baseurl`

    The base URL where the path is appended in HTTP requests to retrieve artifacts.

### S3 Downloader

The following keys are used when the downloader type is "s3".

  * `s3_bucket`

    The S3 bucket from which to retrieve artifacts.

  * `s3_region`

    The S3 region in which the repository bucket exists.

  * `s3_retry_limit`

    The maximum number of attempts to download. Defaults to 5.

  * `s3_concurrency`

    The maximum number of concurrent parts to download from S3. Defaults to 5.
    
  * `timeout`

    The max time in seconds the download must complete in. Defaults to 300 (5 minutes)
    
  * `access_key`

    The AWS access key to use when authenticating.

  * `secret_key`

    The AWS secret access key to use when authenticating.
