States
========

About
------

Has both remote (deploy,rollback) and local (install,restart) context


Deploy Command
----------------

* get command options (owner,repo,environment)
* get 'deployed-version' key from consul (or fallback consul if that fails)
* get repositories settings from skadi
* depending on settings.Deploy.Artifact value is tar or pkg style deploy
* distribution style setting from skadi for fast=(all nodes at once, remotely) or gradual=local

Tar (Local Install)
-----------------------

* metadata
    * get repo/dir/target/sha/environment from arguments
    * load courier.conf config and get S3 access info
    * get current version in use from the current symlink
* check current downloaded releases, and symlink it if one matches what we are going to
* get the tarball
  * get tarfile from S3
  * extract tarball
  * move signed manifest
  * run post install
  * release symlink (aka create current symlink)
  * cleanup old releases
* extract release/tarball
* restart service (may call one of 3 things):
    * restart-service.sh
    * restart-service (non-shell script executable)
    * or svc -<foo>  (if a 'service' is set in deploy.json)

Pkg (Local Install)
-----------------------

* metadata
  * get target/sha from arguments, or last good version in consul
    * "Fast rollbacks" are automated via the deb/rpm already existing in the package cache   
    * No target flag. Packages install where they install.
    * No dir flag. Packages install where they install.
    * No symlink flags. Symlinks are handled by the package.
    * No config flag. Nothing to configure.
    * No restart control. Restarts are handled by the package. Calling restart.sh scripts (if provided) is the responsibility of the package.
    * Standards for packages maintained by bobsled team. See bobsled project (#bobsled-dev) for details on bobsled. 
* determine OS to figure out package management backend (apt/yum)
* update package lists
* install the package. Package must handle symlinking itself and restarting itself in post-install scripts

Responsibility of package:
* register itself with service handler via symlinking itself in post-install script
* restart itself in post-install script

Responsibility of courier:
* communicate the SHA of artifact and target from skadi to the package installer
* communicate the success of install back to skadi
