job {
	name 'release-courier'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/courier', 'ssh', 'git.xarth.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v'
    shell "mkdir -p fpm_source/usr/bin"
    shell "mv .manta/courier fpm_source/usr/bin"
    fpmPackageFromDir 'deb'
    fpmPackageFromDir 'rpm'
    shell "mkdir fpm_out"
    shell "mv *.deb fpm_out/courier.deb"
    shell "mv *.rpm fpm_out/courier.rpm"
    saveDeployArtifact 'release/courier', 'fpm_out'
	}
}

job {
	name 'release-courier-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/courier'
		uploadDeb("courier.deb")
    uploadRPM('courier.rpm')
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			string('dta_tools_deploy', 'dtatoolsdeploy')
			file('AWS_CONFIG_FILE', 'aws_config')
			file('ARTI_CONFIG_FILE', 'dta_arti_creds')
		}
	}
}

job {
	name 'release-courier-integration-tar'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/courier-integration-tar', 'ssh', 'git.xarth.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		saveDeployArtifact 'release/courier-integration-tar', '.'
	}
}
