package artifact

import (
	"io/ioutil"
	"log"
	"net"
	"net/http"
	"net/url"
	"os"
	"testing"
)

// Checks that HTTPDownloader.Download writes the correct content
func TestHTTPDownloaderDownloadContent(t *testing.T) {
	testPath, testContent := "/foo/bar/1234.tgz", "hello"
	testRepo, testSHA := "foo/bar", "1234"
	l, err := net.Listen("tcp", "127.0.0.1:0")
	if err != nil {
		t.Fatal(err)
	}
	defer l.Close()
	m := http.NewServeMux()
	m.HandleFunc(testPath, func(w http.ResponseWriter, req *http.Request) {
		_, err := w.Write([]byte(testContent))
		if err != nil {
			t.Fatal(err)
		}
	})
	go func() {
		err = http.Serve(l, m)
		if err != nil {
			log.Print(err)
		}
	}()
	downloader := &HTTPDownloader{
		BaseURL: &url.URL{Scheme: "http", Host: l.Addr().String()},
	}
	tarFile, err := ioutil.TempFile("", "courier")
	if err != nil {
		t.Fatal(err)
	}
	defer os.Remove(tarFile.Name())
	_, err = downloader.DownloadArtifact(tarFile, testRepo, testSHA)
	if err != nil {
		t.Fatalf("HTTPDownloader.Download had an error on getting repo %s sha %s: %v", testRepo, testSHA, err)
	}
	tarFile.Seek(0, 0)
	content, err := ioutil.ReadAll(tarFile)
	if err != nil {
		t.Fatal(err)
	}
	if string(content) != testContent {
		t.Errorf("File content is different from test content\nGot: %s\nExpected: %s", content, testContent)
	}
}
