package common

import (
	"fmt"
	"path/filepath"
	"strings"
)

func CalculateFailRate(total int, fail int) float32 {
	if total <= 0 || fail <= 0 {
		return 0
	}
	if total <= fail {
		return 100
	}
	return (float32(fail) * 100 / float32(total))
}

func ParseVersion(target string) (string, error) {
	// assuming extract directory is of form timestamp-sha, we want the sha
	starget := strings.SplitN(filepath.Base(target), "-", 2)
	if len(starget) != 2 || len(starget[0]) == 0 || len(starget[1]) == 0 {
		return "", fmt.Errorf("%q does not match expected format; Expected: <ts>-<sha>", target)
	}
	return starget[1], nil
}

func SplitStringWithoutEmptyStr(s string, sep string) []string {
	newstrs := []string{}
	for _, s1 := range strings.Split(s, sep) {
		s2 := strings.TrimSpace(s1)
		if s2 == "" {
			continue
		}
		newstrs = append(newstrs, s2)
	}
	return newstrs
}
