package common

import (
	"fmt"
)

//
// These are actually tests. Go matches the output of the logic with "Output:" sections comments.
// If output doesn't match, it'll report an error. It's just a lot easier doing these tests in this way.
//

func Example_CalculateFailRate() {
	fmt.Println(CalculateFailRate(0, 0))
	fmt.Println(CalculateFailRate(1, 1))
	fmt.Println(CalculateFailRate(99, 0))
	fmt.Printf("%.2f\n", CalculateFailRate(99, 3))
	fmt.Printf("%.2f\n", CalculateFailRate(99, 10))
	fmt.Println(CalculateFailRate(99, 99))
	fmt.Println(CalculateFailRate(99, 100))

	// Output:
	// 0
	// 100
	// 0
	// 3.03
	// 10.10
	// 100
	// 100
}

func Example_ParseVersion() {
	fmt.Println(ParseVersion(""))
	fmt.Println(ParseVersion("-"))
	fmt.Println(ParseVersion("20170515215305"))
	fmt.Println(ParseVersion("20170515215305-"))
	fmt.Println(ParseVersion("-63052dbe3a05e65e0572e6c35fa9318bb471cf99"))
	fmt.Println(ParseVersion("20170515215305-63052dbe3a05e65e0572e6c35fa9318bb471cf99"))

	// Output:
	// "" does not match expected format; Expected: <ts>-<sha>
	//  "-" does not match expected format; Expected: <ts>-<sha>
	//  "20170515215305" does not match expected format; Expected: <ts>-<sha>
	//  "20170515215305-" does not match expected format; Expected: <ts>-<sha>
	//  "-63052dbe3a05e65e0572e6c35fa9318bb471cf99" does not match expected format; Expected: <ts>-<sha>
	// 63052dbe3a05e65e0572e6c35fa9318bb471cf99 <nil>
}

func Example_SplitStringWithoutEmptyStr() {
	fmt.Println(SplitStringWithoutEmptyStr("", ","))
	fmt.Println(SplitStringWithoutEmptyStr("a,b,c", ","))
	fmt.Println(SplitStringWithoutEmptyStr("a,,b", ","))
	fmt.Println(SplitStringWithoutEmptyStr(",a,,b,,", ","))
	fmt.Println(SplitStringWithoutEmptyStr(",,,, ,   ,", ","))

	// Output:
	// []
	// [a b c]
	// [a b]
	// [a b]
	// []
}
