package pack

import (
	"testing"

	"code.justin.tv/release/courier/pkg/structs"
)

// TestLocalInstall is for testing that LocalInstall fails if the correct flags
// aren't passed in. This feels like I'm writing Ruby.
func TestLocalInstallErrs(t *testing.T) {
	type localInstallTest struct {
		testName string
		repo     string
		sha      string
	}

	tests := []localInstallTest{
		{
			testName: "emptyRepo",
			repo:     "",
			sha:      "abcd",
		},
		{
			testName: "emptyEnvironment",
			repo:     "foo",
			sha:      "abcd",
		},
		{
			testName: "emptyDir",
			repo:     "foo",
			sha:      "abcd",
		},
		{
			testName: "emptySha",
			repo:     "foo",
			sha:      "",
		},
		{
			testName: "emptyTarget",
			repo:     "foo",
			sha:      "abcd",
		},
	}
	options := structs.Options{}
	c, err := NewCourier(&options)
	if err != nil {
		t.Fatalf("Error creating NewCourier: %v", err)
	}
	for _, test := range tests {
		err := c.LocalInstall(test.repo, test.sha)
		if err == nil {
			t.Errorf("%q: Want err; got nil", test.testName)
		}
		if !IsArgErr(err) {
			t.Errorf("%q: Want invalid argument error; got %v", test.testName, err)
		}
	}
}
