package structs

import (
	"flag"
	"fmt"
	"github.com/codegangsta/cli"
	"io/ioutil"
	"os"
)

//
// These are actually tests. Go matches the output of the logic with "Output:" sections comments.
// If output doesn't match, it'll report an error. It's just a lot easier doing these tests in this way.
//

func Example_ReadMultiEnvHosts() {
	os.Setenv("HOSTS", "a")
	os.Setenv("HOSTS2", "b")
	os.Setenv("HOSTS3", "c")
	os.Setenv("HOSTS5", "e")
	fmt.Println(readMultiEnvHosts())
	os.Unsetenv("HOSTS")
	for i := 2; i < 10; i++ {
		os.Unsetenv(fmt.Sprintf("HOSTS%d", i))
	}

	// Output:
	// a,b,c
}

func Example_RemoveHosts() {
	o := &Options{Hosts: []string{"a", "b", "c", "d"}}
	o.RemoveHosts([]string{"b", "c"})
	fmt.Println(o.Hosts)

	o = &Options{Hosts: []string{"a", "b", "c", "d"}}
	o.RemoveHosts([]string{})
	fmt.Println(o.Hosts)

	o = &Options{Hosts: []string{}}
	o.RemoveHosts([]string{"b", "c"})
	fmt.Println(o.Hosts)

	// Output:
	// [a d]
	// [a b c d]
	// []
}

func Example_NewOptions() {
	set := flag.NewFlagSet("test", 0)
	set.String("consul-host", "localhost:8500", "")
	set.String("consul-fallback-dc", "wanmaster", "")
	c := cli.NewContext(nil, set, nil)
	o := NewOptions(c)
	fmt.Println(o.ConsulHost)
	fmt.Println(o.ConsulFallbackDC)

	// Output:
	// localhost:8500
	// wanmaster
}

func Example_NewOptions_FromFile() {
	var testConfig = `
	{"consul_host":"myhost:1234","consul_fallback_dc":"mydc"}
	`
	testFile, err := ioutil.TempFile("", "couriercfgtest")
	if err != nil {
		fmt.Println(err)
		return
	}
	_, err = testFile.WriteString(testConfig)
	if err != nil {
		fmt.Println(err)
		return
	}
	defer os.Remove(testFile.Name())

	set := flag.NewFlagSet("test", 0)
	set.String("config-path", testFile.Name(), "")
	set.String("consul-host", "localhost:8500", "")
	set.String("consul-fallback-dc", "wanmaster", "")
	c := cli.NewContext(nil, set, nil)
	o := NewOptions(c)
	fmt.Println(o.ConsulHost)
	fmt.Println(o.ConsulFallbackDC)

	// Output:
	// myhost:1234
	// mydc
}
