// +build package_integration

// The above blank line is required!!!
//
// Package Integration Tests will only run if you specify the -tags=package_integration flag to
// go test.
package tests

import (
	"fmt"
	"os"
	"os/exec"
	"strings"
	"testing"

	"code.justin.tv/release/courier/tests/setup"
)

var bin string

func TestMain(m *testing.M) {
	setup.Setup()
	bin = setup.Bin
	m.Run()
	setup.Teardown()
}

func TestInstallPackage(t *testing.T) {
	if err := runPackageIntegration("pkg", "install", bin, "video/goingest", "--environment", "beta"); err != nil {
		t.Fatal(err)
	}

	// The intention here is to eventually switch this to a bobsled example project, but
	// goingest is the closest thing to that right now. Ping @jgarneau if this still uses goingest in 2019
	targetDir := "/var/lib/service/goingest"
	serviceDir := "/etc/service/goingest"

	// Test that /etc/service/<service> exists
	targetDirInfo, err := os.Stat(targetDir)
	if err != nil {
		t.Fatalf("Error opening %q: %v", targetDir, err)
	}
	if !targetDirInfo.Mode().IsDir() {
		t.Fatalf("Target dir %q is not a directory.", targetDir)
	}

	// Test if symlink points to /var/lib/service/<service>
	res, err := os.Readlink(serviceDir)
	if err != nil {
		t.Fatalf(`Unable to access %q directory doesn't exist: %v`, serviceDir, err)
	}
	if res != targetDir {
		t.Fatalf("symlink for current -> %q; want %q", res, targetDir)
	}

	// clean up
	if err := runPackageIntegration("pkg", "remove", bin, "video/goingest"); err != nil {
		t.Fatal(err)
	}
}

func TestInstallPackageBySha(t *testing.T) {
	if err := runPackageIntegration("pkg", "install", bin, "video/goingest",
		"--sha", "e9760378fdc7755515d42ad219bab062ad6d81ba"); err != nil {
		t.Fatal(err)
	}

	// The intention here is to eventually switch this to a bobsled example project, but
	// goingest is the closest thing to that right now. Ping @jgarneau if this still uses goingest in 2019
	targetDir := "/var/lib/service/goingest"
	serviceDir := "/etc/service/goingest"

	// Test that /etc/service/<service> exists
	targetDirInfo, err := os.Stat(targetDir)
	if err != nil {
		t.Fatalf("Error opening %q: %v", targetDir, err)
	}
	if !targetDirInfo.Mode().IsDir() {
		t.Fatalf("Target dir %q is not a directory.", targetDir)
	}

	// Test if symlink points to /var/lib/service/<service>
	res, err := os.Readlink(serviceDir)
	if err != nil {
		t.Fatalf(`Unable to access %q directory doesn't exist: %v`, serviceDir, err)
	}
	if res != targetDir {
		t.Fatalf("symlink for current -> %q; want %q", res, targetDir)
	}

	// clean up
	if err := runPackageIntegration("pkg", "remove", bin, "video/goingest"); err != nil {
		t.Fatal(err)
	}
}

func runPackageIntegration(style, sub, bin, repo string, additionalFlags ...string) error {
	parts := strings.Split(sub, " ")
	args := []string{style}
	args = append(args, parts[0])
	if len(parts) > 1 {
		args = append(args, parts[1])
	}
	args = append(args, []string{
		"--repo", repo,
		"--consul-host", "api.us-west-2.prod.consul.live-video.a2z.com",
	}...)
	args = append(args, additionalFlags...)
	cmd := exec.Command(bin, args...)
	cmd.Stdout, cmd.Stderr = os.Stdout, os.Stderr
	if err := cmd.Run(); err != nil {
		return fmt.Errorf("Error running courier: %v", err)
	}
	return nil
}
