package setup

import (
	"log"
	"os"

	"code.justin.tv/release/gocmd"
)

var (
	// Location of courier binary
	Bin string
)

const (
	ImportPath = "code.justin.tv/release/courier/cmd/courier"
)

func Setup() {
	builder, err := gocmd.NewCmd()
	if err != nil {
		log.Fatal(err)
	}
	Bin, err = builder.Build(ImportPath)
	if err != nil {
		log.Fatalf("error building binary: %v", err)
	}
	log.Println("Built courier at:", Bin)
}

func Teardown() {
	err := os.Remove(Bin)
	if err != nil {
		log.Fatalf("error deleting binary: %v", err)
	}
}
