About SolidSQS
==============
Package solidsqs provides simplified methods to use of AWS SQS.
It's intended to provide a set of helper methods that covers the most of
common use cases in reliable way.

SolidSQS treats and generalizes SQS as a standard FIFO queue model
which has elements in string format. The queue elements in actual SQS
supports attaching a set of attributes to each elements, but SolidSQS
generalizes that part and simplifies the element as a string, so use proper
encoders to send non-string type data.

The biggest problem SolidSQS tries to solve here is to make SQS more
easier to use in reliable way. AWS API is based on fail-and-retry, once
data gets stored it's considered reliable but due to what they call
eventual-consistency and distributed network, it often fails on insertion
and deletion calls. Dealing with all the exceptions on user-land is not
something desirable. SolidSQS tries to provide a middle layer that works
as a reliability controller that helps to minimize user side exception
handling.

One example, SolidSQS doesn't use batch() series calls. When you push '1',
'2', '3', if '2' only failed while '1' and '3' succeeded, it usually only
makes your logic more complicated to fix the failure. This package is focused
on solving those kinds of hassles. Even SolidSQS provides batch()
interface, the underlying implementation doesn't use AWS's batch logic except
of read-only stuff.

For an example, Pop is a transactional operation of peek + delete combo,
let's say it reads 4 messages, 1~4, and failed at deleting 3, then it will
return only 1 and 2. And your next call will get the next from there.

Deletion also can be handled in asynchronous manner, in this case it reads
and returns all then background process will take care of the deletion.
This could be useful when you need to read all the messages from a queue
at the fastest possible way in use-and-forget passion.
It works like a buffered garbage collector. And SQS's visibility feature will
ensure the data not to be available to other clients until they gets
deleted.

SolidSQS tries to provide natural way of queue handling that we usually
think of without bounded by AWS's SQS specific limitations.
If you're looking for more generic SQS helper implementation, please
take a look at `common/messagequeue` package.

Note that Amazon SQS makes a best effort to preserve the order of messages,
but it doesn't guarantee you will receive messages in the exact order you
sent them. So if preserving order of messages is critical, you should
consider another solution.

QUICK EXAMPLE
=============
```go
s, err := solidsqs.New(TestQueueUrl, &aws.Config{Region: aws.String(TestQueueRegion)}, nil)
if err == nil {
    if num, err := s.Push("insert1", "insert2", "insert3"); err == nil {
        if values, err := s.Pop(3, 1); err == nil {
            // values inserted almost same time could be in mixed order
            sort.Strings(values)
            fmt.Println(num, values)
            return
        }
    }
}
fmt.Println("Error happened somewhere, this is just to show how it works.")
// Output: 3 [insert1 insert2 insert3]
```
