spade-client-go
===============

*Current version: [2.0.1](#201)*

Go client for sending tracking events to Spade.

```go
package main

import (
	"context"
	"log"

	"code.justin.tv/common/spade-client-go/spade"
)

type spadeTesting struct {
	Blob      string  `json:"blob"`
	TestField string  `json:"test_field"`
	Num       float64 `json:"num"`
	Truthy    bool    `json:"truthy"`
	WholeNum  int64   `json:"whole_num"`
}

func main() {
	log.Println("Creating Spade client")
	spadeClient, err := spade.NewClient()
	if err != nil {
		log.Fatalf("Failed to create Spade client: %v", err)
	}

	log.Println("Spade client created, submitting Spade event")
	err = spadeClient.TrackEvent(
		context.Background(),
		"spade_testing",
		&spadeTesting{
			Blob:      "arglebargle",
			TestField: "what?",
			Num:       2.718281828,
			Truthy:    false,
			WholeNum:  42,
		},
	)
	if err != nil {
		log.Printf("Failed to submit Spade event: %v", err)
	}
}
```

## Release notes
### 2.0.1
* Validation now uses gojsonschema to more accurately reflect what Spade accepts.

### 2.0.0
* Spade data is now sent in the body of the POST request instead of as a query
  parameter in the URL.
* By default, events are now sent to the internal Edge endpoint over HTTPS;
  the previous default was the external endpoint over HTTP.
* Some events which would fail in the pipeline anyway (including any attempt to
  use a list as or in the event properties) now fail in the client.
