package rtevent

import (
	"fmt"
	"strings"
)

const (
	myApp         = "dta/rtevent"
	mySha         = "0000000000000000000000000000000000000000"
	myEnvironment = "staging"
)

func ExampleSendDeployEvent() {
	c, _ := NewClient(nil, nil)
	e := &DeployEvent{
		App:         myApp,
		Sha:         mySha,
		Environment: myEnvironment,
		Success:     true,
		Phase:       "distribution",
	}
	err := c.SendDeployEvent(e)
	fmt.Println(err)
	fmt.Println(e.Hostname != "")
	fmt.Println(e.IPAddr != "")
	fmt.Println(e.Success)
	fmt.Println(e.Phase)
	// Output:
	// <nil>
	// true
	// true
	// true
	// distribution
}

func ExampleSendDeployEventViaPublisherClient() {
	c, _ := NewPublisherClient()
	e := &DeployEvent{
		App:         myApp,
		Sha:         mySha,
		Environment: myEnvironment,
		Success:     false,
	}
	err := c.SendDeployEvent(e)
	fmt.Println(err)
	fmt.Println(e.Hostname != "")
	fmt.Println(e.IPAddr != "")
	fmt.Println(e.Success)
	fmt.Println(e.Phase)

	// Output:
	// <nil>
	// true
	// true
	// false
	//
}

func ExampleSendDeployEventOnbehalfWithHostname() {
	c, _ := NewPublisherClient()
	e := &DeployEvent{
		App:         myApp,
		Sha:         mySha,
		Environment: myEnvironment,
		Success:     true,
	}
	err := c.SendDeployEventOnbehalf(e, "deploy.xarth.tv")
	fmt.Println(err)
	fmt.Println(e.Hostname)
	fmt.Println(strings.HasPrefix(e.IPAddr, "10."))
	fmt.Println(e.Success)

	// Output:
	// <nil>
	// deploy.xarth.tv
	// true
	// true

}

func ExampleSendDeployEventOnbehalfWithIpaddr() {
	c, _ := NewPublisherClient()
	e := &DeployEvent{
		App:         myApp,
		Sha:         mySha,
		Environment: myEnvironment,
		Success:     true,
	}
	err := c.SendDeployEventOnbehalf(e, "10.192.66.68")
	fmt.Println(err)
	fmt.Println(e.Hostname)
	fmt.Println(e.IPAddr)
	fmt.Println(e.Success)
	// Output:
	// <nil>
	// 10.192.66.68
	// 10.192.66.68
	// true
}
