package rtevent

import (
	"fmt"
)

func ExampleGenerateEventHeader() {
	var e EventHeader
	generateEventHeader(&e)
	fmt.Println(e.Version == EventMessageVersion)
	fmt.Println(e.Type == EventTypeHeader)
	fmt.Println(e.Hostname != "")
	fmt.Println(e.IPAddr != "")
	// Output:
	// true
	// true
	// true
	// true
}

func ExampleGenerateEventHeader2() {
	var e DeployEvent
	generateEventHeader(&e)
	fmt.Println(e.Version == EventMessageVersion)
	fmt.Println(e.Type == EventTypeDeploy)
	fmt.Println(e.Hostname != "")
	fmt.Println(e.IPAddr != "")
	// Output:
	// true
	// true
	// true
	// true
}

func ExampleGenerateDeployEvent() {
	event := &DeployEvent{
		App:         myApp,
		Sha:         mySha,
		Environment: myEnvironment,
		Success:     true,
		Phase:     "restart",
	}
	checkAndCompleteDeployEvent(event)
	fmt.Println(event.Version == EventMessageVersion)
	fmt.Println(event.App == myApp)
	fmt.Println(event.Sha == mySha)
	fmt.Println(event.Environment == myEnvironment)
	fmt.Println(event.Success)
	fmt.Println(event.Phase)
	// Output:
	// true
	// true
	// true
	// true
	// true
	// restart
}
