skadi
=====

Service to control build and release automation for Twitch-written applications.

[API Documentation](doc/api.md)

[Slack Configuration](doc/chat.md)

```
go build && ./skadi
```

## Local Dev

Add an `/etc/hosts` entry to map localhost to `skadi.local.com` to avoid any localhost callback weirdness.
```
# /etc/hosts
localhost skadi.local.com
```

Set up and connect to vagrant
```
vagrant up
vagrant ssh
```

Set up your Go workspace
```
cd /go/src/code.justin.tv/dta/skadi
# Add godep workspace path to gopath
export GOPATH=$GOPATH:`godep path`
# You can run go install once to cache all packages used by skadi
# This prevents them being rebuilt if they don't have changes
go install
```

Run database migrations
```
goose up
```

Setting up the environment requires various secrets like AWS, Github, and Jenkins.
 - AWS access and secret key can be found in the DTA lastpass account.
 - Github API tokens can be provisioned per user in Github. Skadi needs "Full control of organization hooks"
 and "Access private repositories".
 - Github Client ID and secret can be retreived by using the existing [Skadi Local](https://git.xarth.tv/organizations/release/settings/applications/45)
 or creating a new one. The callback URL endpoint is `/github_oauth_callback`.

```
# Fill in secrets as necessary
export GITHUB_API_TOKEN=
export GITHUB_AUTH_URL=https://git.xarth.tv/login/oauth/authorize
export GITHUB_TOKEN_URL=https://git.xarth.tv/login/oauth/access_token
export GITHUB_CLIENT_ID=
export GITHUB_CLIENT_SECRET=
export GITHUB_HOST=https://git.xarth.tv/api/v3/
export JENKINS_API_TOKEN=
export JENKINS_USER=
export JENKINS_HOST=https://jenkins-og.xarth.tv/
export LOG_LEVEL=debug
export WEBHOOK_URL=http://skadi.local.com:8080/v1/webhook
export API_BASE_URL=http://skadi.local.com:8080/
export QUEUE_REGION=us-west-2
# Used for SQS
export AWS_ACCESS_KEY=
export AWS_SECRET_KEY=
```

Running skadi
```
# Running skadi, and each time you make changes to skadi
go build && ./skadi
# Then visit http://localhost:8080/
```

### Testing webhooks locally

Find API tokens at https://git.xarth.tv/systems/puppet/blob/master/hiera/cluster/skadi.yaml

Set up your environment in vagrant:
```
export GITHUB_API_TOKEN=...
export GITHUB_HOST=https://git.xarth.tv/api/v3/
export JENKINS_API_TOKEN=...
export SLACK_API_TOKEN=...
export AWS_ACCESS_KEY_ID=...     (optional if your box is aws configured)
export AWS_SECRET_ACCESS_KEY=... (optional if your box is aws configured)
export MAX_CONCURRENT_DEPLOYER=30
export QUEUE_URL=https://sqs.us-west-2.amazonaws.com/043714768218/skadi-test-queue
export QUEUE_REGION=us-west-2
export ENABLE_QUEUE_LOG=true
```

View the webhook settings in production at https://git.xarth.tv/organizations/release/settings/hooks

Click through to the _*deploy*_ webhook. Find a webhook call with the desired event type in its request and save the payload to a file. Run curl, with `X-Github-Event` set to the event type you want to test and the `-d` parameter specifying the file with the request payload :
```
curl -H "X-Github-Event: deployment_status" -d @deployment_status.json http://localhost:8080/v1/webhook
```

## Updating the Database

We currently manage the database schema with a migrations system called
[goose](https://bitbucket.org/liamstask/goose). This allows us to write the
migrations as sql files. Goose will then handle the running of the SQL
commands. View the documentation on the goose page for information about how
to run goose up, down and create.

When creating a new goose migration make sure to add the `sql` flag. This
allows our migrations to be actual SQL code rather then writing go commands to
add/remove the tables.

To run goose on a server you will need to temporarily update the
`db/dbconf.yml` file to have the correct connection string. We don't have
accurate information in there due to a prohibition on storing passwords in the
repo.

The connection string can generally be [retrieved from
AWS Parameter Store in twitch-core-service account](https://us-west-2.console.aws.amazon.com/systems-manager/parameters/settings/alpha/skadi/pg-conn-info/description?region=us-west-2&tab=Table).

Once you have the connection info add it to your `db/dbconf.yml`. Then run
`goose up -env staging up`. Changing the environment as needed.
