package api

import (
	"net/http"
	"net/http/httptest"
	"testing"
)

var (
	mux    *http.ServeMux
	client *Client
	server *httptest.Server
)

func setup() {
	mux = http.NewServeMux()
	server = httptest.NewServer(mux)

	client, _ = NewClient(server.URL, nil)
}

func teardown() {
	server.Close()
}

func testMethod(t *testing.T, r *http.Request, want string) {
	if got := r.Method; got != want {
		t.Errorf("Request method: %v, want %v", got, want)
	}
}

func TestNewClient(t *testing.T) {
	c, err := NewClient("http://localhost:8080", nil)
	if err != nil {
		t.Error(err)
	}

	if c.baseURL.String() != "http://localhost:8080" {
		t.Errorf("address not set correctly: %v", c.baseURL)
	}
}
