var app = angular.module('app', ['ui.bootstrap', 'ngRoute', 'ngCookies', 'angularMoment', 'ui.router'])

app.factory('auth_interceptor', ['$cookies', function($cookies) {
  return {
    request: function(config) {
      config.headers['GithubAccessToken'] = $cookies.get('GithubAccessToken')
      return config;
    }
  }
}]);

app.factory('session_control_interceptor', ['$window', '$q', function($window, $q) {
  $window.failed_api_calls = 0;
  $window.successful_api_calls = 0;
  $window.last_error_message = ""
  $window.last_error_request_info = ""
  // When set, all further http requests will be rejected.
  $window.session_expired = false;

  return {
    'request': function(request) {
      last_request = request
      if ($window.session_expired) {
        return $q.reject()
      }
      if (detect_apicall_leak($window)) {
        $window.document.title += " - interrupted"
        $window.session_expired = true
        return $q.reject()
      }
      return request
    },
    'response': function(response) {
      $window.successful_api_calls++;
      return response
    },
    'responseError': function(response) {
      if (response.status >= 500) {
        $window.failed_api_calls++;
        $window.last_error_message = response.status + " " + response.statusText + " - " + JSON.stringify(response.data);
        $window.last_error_request_info = last_request.method + " " + last_request.url;
      }
      return $q.reject(response);
    }
  }

  // This stands as a backup in case it happens to leak for a looping call from otherr places.
  // `repo.api_failed` should be the first place to catch failed api and shows up the Ooops warning.
  function detect_apicall_leak(w) {
    if (typeof w.last_counter_reset == 'undefined' ||
      (((new Date().getTime()) - w.last_counter_reset) > (5 * 60 * 1000))) {
      w.last_counter_reset = new Date().getTime()
      w.failed_api_calls = 0
      w.successful_api_calls = 0
    }

    if (w.failed_api_calls > 10) {
      console.log('Detected too many unexpected errors. ' + w.failed_api_calls)
      return true
    } else if (w.successful_api_calls > 800) {
      // When user stays in active deploy status page, it'll make about 100 requests in 5 minutes.
      // Background status pull will make about 30 requests in 5 minutes and worst scenario there could be
      // 10 of background pull. So including some extra requests, we can tell 500 request in 5 minutes
      // as a maximum requests in normal use. So setting it to 800 should be work to capture only abnormal UI
      // behaviors.
      console.log('Detected too many api calls. ' + w.successful_api_calls)
      return true
    }
    return false
  }
}]);

app.config(['$urlRouterProvider', '$stateProvider', '$httpProvider', function($urlRouterProvider, $stateProvider, $httpProvider) {
  var checkScope = "repo,admin:org_hook"
    $urlRouterProvider.otherwise("/home")
    $urlRouterProvider.rule(function($injector, $location) {
    var path = $location.path();
    var hasTrailingSlash = path[path.length-1] === '/';

    // if the last character is a slash, return the same url without the slash - DTA-1407
    if(hasTrailingSlash) {
      var newPath = path.substr(0, path.length - 1);
      return newPath;
    }
  });

  $stateProvider
    .state('login', {
      url: '/login',
      template: '<a href="/authorize">log in</a>',
      controller: function() {}
    })
    .state('home', {
      abstract: true,
      url: "/home",
      templateUrl: "templates/home.html",
      controller: 'home',
      resolve: {
        config_resolve: ['config', '$cookies', '$location', function(config, $cookies, $location) {
          if ($cookies.get('GithubAccessToken') == null || ! $cookies.get('GithubScope').includes(checkScope)) {
            $location.path('/login')
          } else {
            return config.load()
          }
        }],
        my_repos: ['config_resolve', 'repos', function(config_resolve, repos) {
          return repos.load_my_repos()
        }]
      }
    })
    .state('home.history', {
      url: "",
      templateUrl: "templates/home/history.html",
      controller: 'home.history'
    })
    .state('home.org', {
      url: "/:owner",
      templateUrl: "templates/home/org.html",
      controller: 'home.org'
    })
    .state('home.org_settings', {
      url: "/:owner",
      templateUrl: "templates/home/org_settings.html",
      controller: 'home.org_settings'
    })
    .state('repo', {
      url: '/:owner/:repo',
      abstract: true,
      templateUrl: 'templates/repo.html',
      controller: 'repo',
      resolve: {
        config_resolve: ['config', '$cookies', '$location', function(config, $cookies, $location) {
          if ($cookies.get('GithubAccessToken') == null || ! $cookies.get('GithubScope').includes(checkScope)) {
            $location.path('/login')
          } else {
            return config.load()
          }
        }],
        settings: ['config_resolve', '$stateParams', 'repos', function(config_resolve, $stateParams, repos) {
          return repos.load_settings($stateParams.owner, $stateParams.repo)
        }]
      }
    })
    .state('repo.candidates', {
      url: '',
      templateUrl: 'templates/repo/candidates.html',
      controller: 'repo.candidates'
    })
    .state('repo.status', {
      url: '/status?env',
      templateUrl: 'templates/repo/status.html',
      controller: 'repo.status'
    })
    .state('repo.history', {
      url: '/history?env&count',
      templateUrl: 'templates/repo/history.html',
      controller: 'repo.history'
    })
    .state('repo.environments', {
      url: '/environments',
      templateUrl: 'templates/repo/env.html',
      controller: 'repo.environments'
    })
    .state('repo.deploy', {
      url: '/deploys/:id',
      templateUrl: 'templates/repo/deploy.html',
      controller: 'repo.deploy'
    })
    .state('repo.freezes', {
      url: '/freezes',
      templateUrl: 'templates/repo/freezes.html',
      controller: 'repo.freezes'
    })

  $httpProvider.interceptors.push('auth_interceptor')
  $httpProvider.interceptors.push('session_control_interceptor')
}])
