app.controller('home.history', ['$scope', '$q', '$http', 'config', function($scope, $q, $http, config) {
    $scope.searching = false
	$scope.recent_deploys = []
	$scope.search_window = false

	$scope.search = {
		params: {
			 "count": 10,
			"start": "",
			"end": "",
			"state": "",
			"repo": "",
			"environment": ""
		}
	}

	$scope.global_recent_deploys = function() {
		var deferred = $q.defer()
		$scope.searching = true
		$http.get(config.skadi_host+"/v1/deployments", $scope.search)
			.success(function(deployments) {
				$scope.recent_deploys = deployments
				$scope.searching = false
				deferred.resolve(deployments)
			})
		return deferred.promise
	}

	$scope.do_refresh = function() {
		$scope.global_recent_deploys()
	}

	$scope.do_search = function() {
		if ($scope.search.params.count < 30) {
			$scope.search.params.count = 30
		}
		$scope.global_recent_deploys()
	}

	$scope.open_search = function() {
		$scope.search_window = true
		// prefill and divide start and end time in hour unit
		end = new Date()
		end.setTime(end.getTime() + 1*60*60*1000)
		end.setMinutes(0)
		end.setSeconds(0)
		end.setMilliseconds(0)
		start = new Date()
		start.setTime(end.getTime() - 6*60*60*1000)
		$scope.search.params.start = start
		$scope.search.params.end = end
	}

    $scope.global_recent_deploys()
}])
