app.controller('home.org_settings', ['$rootScope', '$scope', '$stateParams', '$uibModal', 'config', 'repos', 'deployments', 'org_settings', function($rootScope, $scope, $stateParams, $uibModal, config, repos, deployments, org_settings) {
	$scope.owner = $stateParams.owner
	$scope.config = $stateParams.config
	$scope.repos = repos
	$scope.deployments = deployments
	var updateSubEmailsFunc = function() {
		org_settings.getSubEmails($stateParams.owner).then(function(subEmails) {
			for (var i=0; i < subEmails.length; i++) {
				var flags = []
				if (subEmails[i].success) {
					flags.push("Success")
				}
				if (subEmails[i].pending) {
					flags.push("Pending")
				}
				if (subEmails[i].failure) {
					flags.push("Failure")
				}
				flags = flags.join(", ")
				subEmails[i].flags = flags;
			}
			$scope.subEmails = subEmails;
		}, function() {
			$scope.subEmails = undefined;
		})
	}
	updateSubEmailsFunc()
	$rootScope.$on('updateSubEmails', updateSubEmailsFunc)

	$scope.create_subscription_modal = function() {
		var modalInstance = $uibModal.open({
			templateUrl: 'create_subscription_modal.html',
			controller: 'create_subscription_modal',
			resolve: {
				owner: function() {
					return $stateParams.owner
				}
			}
		})
		modalInstance.result.then(function(orgSub) {
			return org_settings.createSubscription($stateParams.owner, orgSub.email, orgSub.successFlag, orgSub.pendingFlag, orgSub.failFlag, orgSub.environment)
		})
	}

	$scope.edit_subscription_modal = function(email, environment) {
		var modalInstance = $uibModal.open({
			templateUrl: 'edit_subscription_modal.html',
			controller: 'edit_subscription_modal',
			resolve: {
				owner: function() {
					return $stateParams.owner
				},
				email: function() {
					return email
				},
				environment: function() {
					return environment
				}
			}
		})
		modalInstance.result.then(function(orgSub) {
			return org_settings.updateSubscription($stateParams.owner, orgSub.email, orgSub.successFlag, orgSub.pendingFlag, orgSub.failFlag, orgSub.environment)
		})
	}

	$scope.delete_subscription_modal = function(email, environment) {
		var modalInstance = $uibModal.open({
			templateUrl: 'delete_subscription_modal.html',
			controller: 'delete_subscription_modal',
			resolve: {
				owner: function() {
					return $stateParams.owner
				},
				email: function() {
					return email
				},
				environment: function() {
					return environment
				}
			}
		})
		modalInstance.result.then(function(orgSub) {
			return org_settings.deleteSubscription($stateParams.owner, orgSub.email, orgSub.environment)
		})
	}
}])


/* this is a parent modal class used to share logic between create and edit modals */
app.controller('parent_modal', ['$scope', 'form', function($scope, form) {

	$scope.flags = {"success":false, "pending": false, "failure":false}
	$scope.disableEmails = false

	$scope.checkFlags = function() {
		var ret = false
		for (var flag in $scope.flags) {
			ret = ret || $scope.flags[flag]
		}
		if (!ret) {
			$scope[form].checkboxFlag.$error.error = true
		} else {
			$scope[form].checkboxFlag.$error.error = false
		}
		return ret
	}

	$scope.disableEmailsChecked = function() {
		$scope.disableEmails = !$scope.disableEmails
		if ($scope.disableEmails) {
			$scope[form].checkboxFlag.$error.error = false
		}
		else {
			$scope.checkFlags()
		}
	}
}])


app.controller('create_subscription_modal', ['$rootScope', '$scope', '$timeout', '$uibModalInstance', '$controller', 'repos', 'owner', function($rootScope, $scope, $timeout, $uibModalInstance, $controller, repos, owner) {
	$controller('parent_modal', {$scope:$scope, form: 'create_subscription_form'});
	$scope.owner = owner
	$scope.validate_error = false
	var availRepos = repos.by_org[owner]
	$scope.repos = repos
	$scope.allEnvironments = []
	for (var repo in availRepos) {
		$scope.repos.load_settings(owner, availRepos[repo].name).then(function(settings) {
			if (settings != null && settings.deploy != null && settings.deploy.environments != null) {
				$scope.allEnvironments = $scope.allEnvironments.concat(Object.keys(settings.deploy.environments))
				$scope.allEnvironments = Array.from(new Set($scope.allEnvironments))
			}
		})
	}

	$scope.create = function() {
		if (!$scope.create_subscription_form.$valid) {
			return
		}
		if (!$scope.disableEmails && !($scope.checkFlags())) {
			$scope.create_subscription_form.$valid = false
			$scope.create_subscription_form.checkboxFlag.$error.error = true
			return
		}
		if ($scope.create_subscription_form.$valid) {
			if ($scope.disableEmails) {
				$scope.orgSub.successFlag = false
				$scope.orgSub.pendingFlag = false
				$scope.orgSub.failFlag = false
			} else {
				$scope.orgSub.successFlag = $scope.flags['success']
				$scope.orgSub.pendingFlag = $scope.flags['pending']
				$scope.orgSub.failFlag = $scope.flags['failure']
			}
			$uibModalInstance.close($scope.orgSub)
			$timeout(function(){$rootScope.$emit('updateSubEmails')}, 1000)
		}
	}

	$scope.cancel = function() {
		$uibModalInstance.dismiss()
	}
}])

app.controller('edit_subscription_modal', ['$rootScope', '$scope', '$timeout', '$uibModalInstance', '$controller', 'owner', 'email', 'environment', function($rootScope, $scope, $timeout, $uibModalInstance, $controller, owner, email, environment) {
	$controller('parent_modal', {$scope:$scope, form: 'edit_subscription_form'});
	$scope.owner = owner
	$scope.email = email
	$scope.environment = environment
	$scope.validate_error = false
	$scope.edit = function() {
		if ($scope.edit_subscription_form.$valid) {
			$scope.orgSub = {} //create this here since we don't create it in the form
			$scope.orgSub.email = email
			$scope.orgSub.environment = environment
			if ($scope.disableEmails) {
				$scope.orgSub.successFlag = false
				$scope.orgSub.pendingFlag = false
				$scope.orgSub.failFlag = false
			} else {
				$scope.orgSub.successFlag = $scope.flags['success']
				$scope.orgSub.pendingFlag = $scope.flags['pending']
				$scope.orgSub.failFlag = $scope.flags['failure']
			}
			$root.$uibModalInstance.close($scope.orgSub)
			$timeout(function(){$rootScope.$emit('updateSubEmails')}, 1000)
		}
	}

	$scope.cancel = function() {
		$uibModalInstance.dismiss()
	}
}])

app.controller('delete_subscription_modal', ['$rootScope', '$scope', '$timeout', '$uibModalInstance', 'owner', 'email', 'environment', function($rootScope, $scope, $timeout, $uibModalInstance, owner, email, environment) {
	$scope.owner = owner
	$scope.email = email
	$scope.environment = environment
	$scope.validate_error = false

	$scope.deleteSub = function() {
		//$scope.email = email
		//$scope.environment = environment
		$scope.orgSub = {}
		$scope.orgSub.email = email
		$scope.orgSub.environment = environment
		$uibModalInstance.close($scope.orgSub)
		$timeout(function(){$rootScope.$emit('updateSubEmails')}, 1000)
	}

	$scope.cancel = function() {
		$uibModalInstance.dismiss()
	}
}])
