app.controller('motd', ['$scope', '$http', '$cookies', '$sce', '$timeout', 'config', function($scope, $http, $cookies, $sce, $timeout, config) {
  $scope.contents = ""
  $scope.show = true
  var updateCount = 0

  $scope.toggle = function() {
    setShow(! $scope.show)
  }

  var setShow = function(onoff) {
    $scope.show = onoff
    $cookies.put("motd_show", ""+onoff)
  }

  var update = function() {
    $http.get(config.skadi_host+"/v1/motd/html")
	  .success(function(body) {
	    if ($scope.show == false && updateCount > 1 && body != $scope.contents) {
          // unfold the view to show new message
          setShow(true)
        }
	    $scope.contents = $sce.trustAsHtml(body)
	    updateCount++
	})
  }

  var run = function() {
    update()
    $timeout(run, 300 * 1000)
  }

  if ($cookies.get("motd_show") == "false") {
    setShow(false)
  }
  run()
}]);
