app.controller('repo.candidates', ['$scope', '$window', '$stateParams', '$uibModal', '$sce', 'deployments', 'candidates', 'freezes', 'artifacts', 'config', 'repos', 'moment', function($scope, $window, $stateParams, $uibModal, $sce, deployments, candidates, freezes, artifacts, config, repos, moment) {
    $scope.owner = $stateParams.owner
    $scope.repo = $stateParams.repo
    $scope.deployments = deployments
    $scope.candidates = candidates
    $scope.freezes = freezes
    $scope.artifacts = artifacts

    // Virtual paging on candidate branches
    // Set the BPP(Branches Per Page)'s initial value. If window height is taller than the number
    // of the initial branches to show, we set higher initial BPP, just enough to fill up the screen
    // and to show the scrollbar.
    $scope.bpp = (window.innerHeight <= 1200) ? 20 : 20 + Math.round((window.innerHeight - 1200) / 50) + 1
    $scope.bpp_step = 20
    $scope.bpp_increase = function() {
        $scope.bpp += $scope.bpp_step
    }
    $scope.bpp_set = function(new_bpp) {
        $scope.bpp = new_bpp
    }
    // Bind scroll event for auto scrolling.
    angular.element($window).bind("scroll", function() {
        if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight) {
            $scope.bpp_increase()
            $scope.$apply()
        }
    });

    $scope.activate = function() {
        deployments.set_environments($stateParams.owner, $stateParams.repo)
        freezes.set_repo($stateParams.owner, $stateParams.repo)
        candidates.set_repo($stateParams.owner, $stateParams.repo).then(function(){})
    }

    $scope.banner = ""
    $scope.activate = function() {
        deployments.set_environments($stateParams.owner, $stateParams.repo)
        freezes.set_repo($stateParams.owner, $stateParams.repo)
        candidates.set_repo($stateParams.owner, $stateParams.repo).then(function(){})
        candidates.get_info()
            .then(function() {
                if (candidates.repoinfo.archived) {
                    var contents = "<span class=\"glyphicon glyphicon-warning-sign\"></span> " +
                        "This repository has been <strong>ARCHIVED</strong> since " +
                        new Date(candidates.repoinfo.updated_at) + "<br><br>"
                    $scope.banner = $sce.trustAsHtml(contents)
                }
            })
    }
    $scope.activate()
    $scope.current_user = candidates.get_current_user()
    $scope.$watch(
        function(){
            return $scope.candidates.get_current()
        }
    )

    $scope.create_freeze = function(current_repo, current_owner, current_user, environments) {
        $scope.open = function($event) {
            $event.preventDefault();
            $event.stopPropagation();

            $scope.opened = true;
        };

        var modalInstance = $uibModal.open({
            templateUrl: 'templates/modal/freeze.html',
            controller: 'create_freeze_modal',
            scope: $scope,
            resolve: {
                current_repo: function() {
                    return current_repo
                },
                current_owner: function() {
                    return current_owner
                },
                current_user: function() {
                    return current_user
                },
                environments: function() {
                    return environments
                },
                freezes: function() {
                    return $scope.freezes
                }
            }
        })

        modalInstance.result.then(function(data) {
            var freeze = data.freeze
            var schedule = data.schedule
            return freezes.create(current_repo, current_owner, current_user, freeze.reason, freeze.environment, schedule)
        })
    }

    $scope.unfreeze = function(current_repo, current_owner, freeze, current_user) {
        var modalInstance = $uibModal.open({
            templateUrl: 'templates/modal/unfreeze.html',
            controller: 'unfreeze_modal',
            resolve: {
                current_repo: function() {
                    return current_repo
                },
                current_owner: function() {
                    return current_owner
                },
                current_reason: function() {
                    return freeze.reason
                },
                creator: function() {
                    return freeze.creator
                },
                environment: function() {
                    return freeze.creator
                }
            }
        })
        modalInstance.result.then(function(settings) {
            return freezes.unfreeze(freeze, current_user)
        })
    }

    $scope.deploy = function(branch, ref, environment, default_description, state) {
        var freeze = $scope.environment_frozen(environment)
        $scope.candidates.is_deploying = true;

        if (freeze) {
            $scope.unfreeze($scope.repo, $scope.owner, freeze.reason, freeze.id, freeze.environment, $scope.candidates.current_user)
        } else if (!$scope.deployable_classes(state)) {
            var modalInstance = $uibModal.open({
            templateUrl: 'deploy_modal.html',
            controller: 'deploy_modal',
            resolve: {
                branch: function() {
                    return branch
                },
                environment: function() {
                    return environment
                },
                artifacts: function() {
                    return $scope.artifacts
                },
                default_description: function() {
                    msgs = default_description.split('\n\n')
                    desc = msgs[0]
                    if (msgs.length > 1) {
                        desc += " - " + msgs[1]
                    }
                    return desc
                },
                ref: function() {
                    return ref
                },
                owner: function() {
                    return $scope.owner
                },
                repo: function() {
                    return $scope.repo
                },
                repos: function() {
                    return repos
                },
            }
            })

            modalInstance.result.then(function(settings) {
                $scope.candidates.is_deploying = false;
                if (settings.freeze.enable) {
                    if (!settings.schedule.manual) {

                        var startMoment = moment()
                        var endMoment = moment().add(settings.schedule.dropDownSelected, 'hours')
                        settings.schedule.startDate = startMoment.toDate()
                        settings.schedule.startTime = startMoment.toDate()
                        settings.schedule.enddate = endMoment.toDate()
                        settings.schedule.endtime = endMoment.toDate()
                        console.log(endMoment.toString())

                    }
                    return [
                        deployments.create(branch, ref, environment, settings.description, settings.codeReviewURL, settings.riskAssessment, settings.triggerSmoca).then(function () {
                            freezes.create($scope.repo, $scope.owner, $scope.candidates.current_user, settings.description, settings.freeze.environment, settings.schedule, settings.autodeploy.enable)
                        })
                    ]
                } else {
                    return deployments.create(branch, ref, environment, settings.description, settings.codeReviewURL, settings.riskAssessment, settings.triggerSmoca)
                }
            }, function() {
                $scope.candidates.is_deploying = false;
                })
        }
    }

    $scope.environment_frozen = function(frozen_env) {
        return freezes.environment_frozen(frozen_env)
    }
    $scope.environment_whitelist = function(environment) {
                var wl = []
                try {
                        wl = repos.settings["deploy"]["environments"][environment]["whitelist"]
                } catch(e) {
                        if (e instanceof TypeError) {
                                wl = []
                        } else {
                                throw(e)
                        }
                }
                if (wl == undefined) {
                        wl = []
                }
                return wl
        }
    $scope.environment_has_whitelist = function(environment) {
                var wl = $scope.environment_whitelist(environment)
                if (wl.length <= 0) { // sane default for when there is no whitelist
                        return false
                }
                return true
    }

    $scope.branch_not_whitelisted = function(environment, branch) {
                var wl = $scope.environment_whitelist(environment)
                if (wl.length <= 0) { // sane default for when there is no whitelist
                        return false
                }
                for (var i = 0; i < wl.length; i++) {
                        if (wl[i] === branch) {
                                return false;
                        }
                }
                return true
    }

    $scope.deployable_classes = function(state) {
        if (state != "success") {
            return true
        }
        return false
    }

    $scope.is_deployable = function(candidate, env) {
        return $scope.get_state(candidate, env) == "success"
    }

    $scope.get_state = function(candidate, env) {
        if (candidate.states.hasOwnProperty(env)) {
            return candidate.states[env]
        }
        return candidate.state
    }

    $scope.write_default_config = function() {
        config.write_default_config($scope.owner, $scope.repo)
            .then(function() {
                repos.load_settings($scope.owner, $scope.repo)
                    .then(function() {
                        $scope.activate()
                    })
            })
    }

    $scope.should_retry = function(state) {
        retryable_states = ["success", "failure", "error", "unknown", "aborted"]
        // A state is retryable if it is contained in retryable_states
        return retryable_states.indexOf(state) != -1
    }

    $scope.rebuild = function(candidate) {
        candidates.rebuild($scope.owner, $scope.repo, candidate.branch)
            .then(function(data) {
                // We don't know what the status of the build is now, mark the status as rebuild
                // and the target_url as empty.
                // This will get updated once the build runs and a poll takes place.
                candidate.state = "rebuild"
                candidate.target_url = "";
            });
    }

    $scope.notifycommit = function(candidate) {
        candidates.notifycommit($scope.owner, $scope.repo, candidate.sha)
            .then(function(data) {
                candidate.state = "rebuild"
                candidate.target_url = "";
            }, function(data){
                alert(data.StatusCode + " " + data.StatusMessage + " - " + data.Error)
            });
    }

    $scope.candidates.reset_candidates()
}])

app.controller('deploy_modal', ['$scope', '$uibModalInstance', 'branch', 'environment', 'default_description', 'artifacts', 'ref', 'owner', 'repo', 'repos', 'deployments', 'freezes', function ($scope, $uibModalInstance, branch, environment, default_description, artifacts, ref, owner, repo, repos, deployments, freezes) {
    $scope.branch = branch
    $scope.environment = environment
    $scope.ref = ref
    $scope.today = function () {
        return new Date();
    };
    $scope.tomorrow =  function() {
        var today = $scope.today()
        today.setDate($scope.today().getDate() + 1)
        return today
    }
    $scope.settings = {
        schedule: {
            type: 'schedule',
            startDate: $scope.today(),
            startTime: new Date(0, 0, 0, 0, 0, 0, 0),
            endDate: $scope.tomorrow(),
            endTime: new Date(0, 0, 0, 0, 0, 0, 0),
            expression: {},
            expression_type: "",
            manual: false,
            dropDownOptions: [
             {time: 1, timeName: '1h'},
             {time: 3, timeName: '3h'},
             {time: 6, timeName: '6h'},
             {time: 12, timeName: '12h'},
             {time: 24, timeName: '24h'},
             {time: 48, timeName: '48h'},
            ],
            dropDownSelected: 1,
        },
        freeze: {
            enable: false,
            reason: null,
            environment: environment
        },
        autodeploy: {
            enable: false,
        }
    }
    if (repos.settings.deploy.environments[environment].subscriptions != null) {
        $scope.settings.description = ""
    } else {
        $scope.settings.description = default_description
    }
    $scope.errorString = null
    $scope.previous_sha = ""
    $scope.owner = owner
    $scope.repo = repo
    $scope.repos = repos
    $scope.artifacts = artifacts.deployed
    $scope.number_of_commits = null

    $scope.recent_deploy = false
    $scope.load_recent_deployment = function() {
        deployments.get_deploys_for_env(environment, 1).then(function(recent_deploys) {
            $scope.recent_deploy = recent_deploys.length > 0 ? recent_deploys[0] : false
        }, function(data) {
            $scope.recent_deploy_error = "Unable to get most recent deploy"
        })
    }

    if (repos.settings.deploy.smoca && (repos.settings.deploy.smoca.opt_out || repos.settings.deploy.smoca.hidden)) {
        $scope.settings.triggerSmoca = true
    }

    $scope.load_deploy_comparison = function () {
        $scope.authors = {}
        $scope.comparison = null
        artifacts.get_comparison_for_env(owner, repo, environment, ref)
            .then(function (comparison) {
                $scope.comparison_complete = true
                $scope.comparison = comparison
                $scope.previous_sha = comparison.previous_sha
                $scope.number_of_commits = comparison.github_compare.commits.length
                if ($scope.number_of_commits) {
                    var commits = comparison.github_compare.commits
                    for (i = 0; i < $scope.number_of_commits; i++) {
                        var author = commits[i].committer.login
                        $scope.authors[author] = true
                    }
                    $scope.authors = Object.keys($scope.authors).join(", ")
                }
            }, function (data) {
                $scope.comparison_complete = true
                var message = "Unable to get commit comparison.";
                if (data.StatusCode === 409) {
                    message = "No previous deployment to compare."
                }
                $scope.comparison_error = message;
            })
    }

    $scope.load_deploy_comparison()
    $scope.load_recent_deployment()

    $scope.ok = function () {
        $uibModalInstance.close($scope.settings)
    }

    $scope.cancel = function () {
        $uibModalInstance.dismiss()
    }
}])
