app.controller('repo.deploy', ['$scope', '$stateParams', '$interval', '$http', '$uibModal', 'config', 'deployments', 'repos', function($scope, $stateParams, $interval, $http, $uibModal, config, deployments, repos) {
	$scope.owner = $stateParams.owner
	$scope.repo = $stateParams.repo
	$scope.deployments = deployments
	$scope.deployment = null
	$scope.state = "unknown"
	$scope.log = ""
	$scope.deploystatus = {
	    stop: 0,
	    updated: 0,
	    progress: 0,
	    successrate: 0,
	    stat: {},
	    hosts: {}
	}
    $scope.status_interval = null
	$scope.activate = function() {
        $scope.deployments.get_deployment($stateParams.id)
        .then(function(deploy) {
            $scope.deployment = deploy
            $scope.deployments.watched_logs[$stateParams.id] = true
            var load_info = function() {
                $scope.deployments.load_deployment_status_for_deploy(deploy, true)
                .then(function() {
                    update_deploystatus($scope.deployment)
                    var state = get_deploy_state($scope.deployments, deploy.id)
                    if ($scope.status_interval && (state == "success" || state == "failure" || state == "error" || state == "aborted")) {
                        $scope.state = state
                        // we need to get deploystatus updated after getting the final state to compensate the delay in event delivery.
                        if ($scope.deploystatus.stop > 0) {
                            $interval.cancel($scope.status_interval)
                            $scope.status_interval = null
                        }
                        $scope.deploystatus.stop++
                    }
                })
            }
            $scope.status_interval = $interval(load_info, 3000)
            $scope.$on('$destroy', function() {
                $interval.cancel($scope.status_interval)
            })
            $scope.get_log()
        })
	}
	$scope.activate()

	$scope.get_log = function() {
		$scope.deployments.get_log_output($scope.deployment.id)
			.then(function(log) {
				$scope.log = log
			})
	}

	$scope.$watch(
		function(){
			if ($scope.deployment){
				return $scope.deployments.logs[$scope.deployment.id]
			} else {
				return 0
			}

		},
		function(){
			if ($scope.deployment && $scope.deployments.logs[$scope.deployment.id]) {
				$scope.log = $scope.deployments.logs[$scope.deployment.id]
			}
		}
	)

	$scope.$watch(
		function(){
			return $scope.deployments.watched_logs[$stateParams.id]
		},
		function(){
			if ($scope.deployment && !$scope.deployment.jenkinsjob){
				$scope.deployments.get_deployment($stateParams.id)
					.then(function(deploy) {
						$scope.deployment = deploy
					})
			}
		}
	)

	$scope.deploy_status_for = function(deploy_id) {
			classes = ["glyphicon"]
			var state = get_deploy_state($scope.deployments, deploy_id)
			classes.push(state)
			switch (state) {
				case "success":
					classes.push("glyphicon-ok")
					break
				case "pending":
					classes.push("glyphicon-time")
					break
				case "failure":
				case "error":
				case "aborted":
					classes.push("glyphicon-remove")
					break
				case "unknown":
					classes.push("glyphicon-question-sign")
					break
			}

			return classes
		}

    function get_deploy_state(deployments, id) {
        var state = "unknown"
        if (deployments.statuses[id]) {
            state = deployments.statuses[id].state
        }
        return state
    }

	var update_deploystatus = function(deployment) {
        $http.get(config.skadi_host+"/v1/deployments/"+deployment.id+"/deploystatus")
    	    .success(function(r) {
    	    var hosts = {"success": [], "progress": [], "failure": [], "unknown": []}
    	    r["hosts"].forEach(function(h) {
                if (h.ipaddr == "") {
                    h.ipaddr = "?.?.?.?"
                }
                if (h.datacenter === undefined) {
                    h.datacenter = "unknown"
                }

                h["title"] = h.hostname
                h["detail"] = h.datacenter+" / "+h.ipaddr+" / "+h.health+" / "+h.updated
                if (h.status == "failure") {
                    h["detail"] += " / \""+h.desc+"\""
                    hosts["failure"].push(h)
                } else if (h.status == "success") {
                    if (h.phase == "restart-remote") {
                        hosts["success"].push(h)
                    } else {
                        hosts["progress"].push(h)
                    }
        	    } else {
                    hosts["unknown"].push(h)
        	    }
    	    })
            for (var key in hosts) {
                hosts[key].sort(function (a, b) {
                    return (a.hostname > b.hostname) ? 1 : (a.hostname < b.hostname) ? -1 : 0
                })
            }
            $scope.deploystatus.stat = r["host-stat"]
            $scope.deploystatus.hosts = hosts
            if (r["host-stat"]["num-success"] > 0) {
                $scope.deploystatus.progress = Math.round(100 * (r["host-stat"]["num-success"] + r["host-stat"]["num-failure"]) / r["host-stat"]["total-hosts"] )
                $scope.deploystatus.successrate = Math.round(100 * r["host-stat"]["num-success"] / r["host-stat"]["total-hosts"] )
            }

            $scope.deploystatus.updated++

            if (r["host-stat"]["total-hosts"] == 0 || $scope.deploystatus.progress == 100) {
                $scope.deploystatus.stop++
            }
       	    //alert(JSON.stringify(r))
    	})
	}


    $scope.partialredeploy = function(hosts) {
		var modalInstance = $uibModal.open({
			templateUrl: 'templates/modal/partialredeploy.html',
			controller: 'partialredeploy_modal',
			resolve: {
                deployment: function() {
                    return $scope.deployment
                },
                deploystatus: function() {
                    return $scope.deploystatus
				},
                hosts: function() {
                    return hosts
                }
			}
		})

		modalInstance.result.then(function(settings) {
			deployments.set_environments($scope.owner, $scope.repo)
			return deployments.create($scope.deployment.branch, $scope.deployment.sha, $scope.deployment.environment, settings.description, "", "", null, settings.hosts, $scope.deployment.id)
		})
	}
}])

app.controller('partialredeploy_modal', ['$scope', '$uibModalInstance', 'deployment', 'deploystatus', 'hosts', function ($scope, $uibModalInstance, deployment, deploystatus, hosts) {
    $scope.deployment = deployment
	$scope.deploystatus = deploystatus

    $scope.hostsList = []
    $scope.hostsStatus = {}
    $scope.hostsSelected = {}
    $scope.settings = {}
    $scope.settings.description = "Partial redeploy from deploy "+deployment.id+": "+deployment.branch+"@"+deployment.sha.substring(0, 8)+" to "+deployment.environment+" environment"
    $scope.settings.hostsInclude = {"failure":true, "progress":false, "unknown":false}
    $scope.settings.hosts = ""
    $scope.def_check = true

    $scope.refresh = function() {
        $scope.hostsList = []
        for (var t in $scope.settings.hostsInclude) {
            for (var key in deploystatus.hosts[t]) {
                h = deploystatus.hosts[t][key]
                $scope.hostsList.push(h.hostname)
                $scope.hostsStatus[h.hostname] = t
            }
            $scope.selectHosts(t)
        }
    }

    $scope.selectHosts = function(category) {
        for (var t in $scope.settings.hostsInclude) {
            if (t != category) {
                continue
            }
            for (var key in deploystatus.hosts[t]) {
                h = deploystatus.hosts[t][key]
                $scope.hostsSelected[h.hostname] = $scope.settings.hostsInclude[category]
            }
        }
    }

    $scope.ok = function () {
        var hosts = []
        for (var name in $scope.hostsSelected) {
            if ($scope.hostsSelected[name]) {
                hosts.push(name)
            }
        }
        if (hosts.length > 0) {
            $scope.settings.hosts = hosts.join()
            $uibModalInstance.close($scope.settings)
        }
    }

    $scope.cancel = function () {
        $uibModalInstance.dismiss()
    }

    $scope.refresh()
}])
