app.controller('repo.environments', ['$scope', '$stateParams', 'artifacts', function ($scope, $stateParams, artifacts) {
	$scope.owner = $stateParams.owner
	$scope.repo = $stateParams.repo
	$scope.artifacts = artifacts

	$scope.activate = function () {
		artifacts.set_repo($stateParams.owner, $stateParams.repo)
	}
	$scope.activate()

	$scope.showLatestWarning = function (latest, current) {
		if (!latest) {
			// Show warning, we weren't given a valid sha
			return true
		}

		return latest !== current
	}

	$scope.latestWarningMessage = function (latest, current) {
		if (!latest) {
			return "Unable to retrieve branch head"
		}

		return "Branch head is newer than environment commit"
	}

	$scope.show = {}
	$scope.toggleShow = function (env) {

		$scope.show[env] = !$scope.show[env]
	}
}])
