app.controller('repo.freezes',
    ['$scope', '$stateParams', '$uibModal', 'freezes', 'users',
        function ($scope, $stateParams, $uibModal, freezes, users) {
            $scope.owner = $stateParams.owner
            $scope.repo = $stateParams.repo
            $scope.freezes = freezes
            $scope.users = users

            users.get_current_user()

            $scope.activate = function () {
                freezes.set_repo($stateParams.owner, $stateParams.repo)
            }
            $scope.activate()

            $scope.weeklyRepeatFormat = function (expression) {
                var message = ""
                if (!expression) {
                    return message
                }

                return freezes.printWeeklyRepeat(expression.start_day, expression.end_day, new Date(expression.start_time), new Date(expression.end_time))
            }

            $scope.unfreeze = function (freeze) {
                var modalInstance = $uibModal.open({
                    templateUrl: 'templates/modal/unfreeze.html',
                    controller: 'unfreeze_modal',
                    resolve: {
                        current_repo: function () {
                            return $scope.repo
                        },
                        current_owner: function () {
                            return $scope.owner
                        },
                        current_reason: function () {
                            return freeze.reason
                        },
                        creator: function () {
                            return freeze.creator
                        },
                        environment: function () {
                            return freeze.environment
                        }
                    }
                })
                modalInstance.result.then(function (settings) {
                    return freezes.unfreeze(freeze, $scope.users.current_user)
                })
            }
        }])
