app.controller('repo.history', ['$scope', '$stateParams', '$state', 'deployments', 'artifacts', '$uibModal', 'repos', function($scope, $stateParams, $state, deployments, artifacts, $uibModal, repos) {
	$scope.owner = $stateParams.owner
	$scope.repo = $stateParams.repo
	$scope.deployments = deployments
	$scope.count_options = ['10', '20', '50', '100']

	$scope.activate = function() {
		deployments.set_environments($scope.owner, $scope.repo)
		if ($stateParams.env != null) {
			$scope.selected_history_env = $stateParams.env
		} else {
			$scope.selected_history_env = deployments.environments[0]
		}
		if ($stateParams.count != null) {
			$scope.selected_history_count = $stateParams.count
		} else {
			$scope.selected_history_count = "10"
		}
		deployments.set_recent_deploy_events_for_env($scope.selected_history_env, $scope.selected_history_count)
	}
	$scope.activate()

	$scope.select_env = function() {
		$state.go('repo.history', {env: $scope.selected_history_env, count: $scope.selected_history_count})
	}

	$scope.select_count = function() {
		$state.go('repo.history', {count: $scope.selected_history_count, env: $scope.selected_history_env})
	}

	$scope.deploy_status_for = function(deploy_id) {
		classes = ["glyphicon"]
		state = "unknown"

		if (deployments.statuses[deploy_id]) {
			state = deployments.statuses[deploy_id].state
		}

		classes.push(state)

		switch (state) {
			case "success":
				classes.push("glyphicon-ok")
				break
			case "pending":
				classes.push("glyphicon-time")
				break
			case "failure":
			case "error":
			case "aborted":
				classes.push("glyphicon-remove")
				break
			case "unknown":
				classes.push("glyphicon-question-sign")
				break
		}

		return classes
	}

	$scope.isDeploymentEvent = function(evnt) {
		return evnt.event_type === "deployment"
	}

	$scope.isFreezeEvent = function(evnt) {
		return evnt.event_type === "freeze"
	}

	$scope.redeploy = function(branch, ref, environment, description, owner, repo, codeReviewURL, riskAssessment) {
		var redeployPrefix = "[redeploy] "
		var modalInstance = $uibModal.open({
		templateUrl: 'redeploy_modal.html',
		controller: 'redeploy_modal',
		resolve: {
			branch: function() {
				return branch
			},
			environment: function() {
				return environment
			},
			artifacts: function() {
				return artifacts
			},
			default_description: function() {
				return redeployPrefix + description
			},
			ref: function() {
				return ref
			},
			owner: function() {
				return owner
			},
			repo: function() {
				return repo
			},
			repos: function() {
				return repos
			},
			codeReviewURL: function() {
				return codeReviewURL
			},
			riskAssessment: function() {
				return redeployPrefix + riskAssessment
			}
		}
		})

		modalInstance.result.then(function(settings) {
			return deployments.create(branch, ref, environment, settings.description, settings.codeReviewURL, settings.riskAssessment)
		})
	}
}])

app.controller('redeploy_modal', ['$scope', '$uibModalInstance', 'branch', 'environment', 'default_description', 'artifacts', 'ref', 'owner', 'repo', 'repos', 'codeReviewURL', 'riskAssessment', function($scope, $uibModalInstance, branch, environment, default_description, artifacts, ref, owner, repo, repos, codeReviewURL, riskAssessment) {
	$scope.branch = branch
	$scope.environment = environment
	$scope.ref = ref
	$scope.settings = {}
	if (repos.settings.deploy.environments[environment].subscriptions != null) {
		$scope.settings.description = ""
	} else {
		$scope.settings.description = default_description
	}
	$scope.previous_sha = ""
	$scope.owner = owner
	$scope.repo = repo
	$scope.repos = repos
	$scope.artifacts = artifacts.deployed
	$scope.number_of_commits = null
	$scope.settings.codeReviewURL = codeReviewURL
	$scope.settings.riskAssessment = riskAssessment

	$scope.load_deploy_comparison = function() {
		$scope.authors = {}
		$scope.comparison = null
		artifacts.get_comparison_for_env(owner, repo, environment, ref)
			.then(function(comparison){
				$scope.comparison_complete = true
				$scope.comparison = comparison
				$scope.previous_sha = comparison.previous_sha
				$scope.number_of_commits = comparison.github_compare.commits.length
				if($scope.number_of_commits) {
					var commits = comparison.github_compare.commits
					for ( i = 0; i < $scope.number_of_commits; i++) {
						var author = commits[i].committer.login
						$scope.authors[author] = true
					}
					$scope.authors = Object.keys($scope.authors).join(", ")
				}
			}, function(data) {
				$scope.comparison_complete = true
				var message = "Unable to get commit comparison.";
				if (data.StatusCode === 409) {
					message = "No previous deployment to compare."
				}
				$scope.comparison_error = message;
			})
	}

	$scope.load_deploy_comparison()

	$scope.ok = function() {
		$uibModalInstance.close($scope.settings)
	}

	$scope.cancel = function() {
		$uibModalInstance.dismiss()
	}
}])
