app.controller('create_freeze_modal',
	['$scope', '$uibModalInstance', 'current_repo', 'current_owner', 'current_user', 'environments', 'freezes',
		function ($scope, $uibModalInstance, current_repo, current_owner, current_user, environments, freezes) {
			$scope.repo = current_repo
			$scope.owner = current_owner
			$scope.user = current_user
			$scope.environments = environments
			$scope.freeze = {}
			$scope.schedule = {}
			$scope.freezes = freezes
			$scope.invalid = false

			$scope.today = function () {
				return new Date();
			};

			$scope.environment_frozen = function (frozen_env) {
				if ($scope.shouldSchedule) {
					$scope.invalid = false
					return false
				}

				var freeze = freezes.environment_frozen(frozen_env)
				if (freeze) {
					$scope.invalid = true
					return true
				} else {
					$scope.invalid = false
					return false
				}
			}

			$scope.create = function () {
				if ($scope.create_freeze_form.$valid) {
					$uibModalInstance.close({ freeze: $scope.freeze, schedule: $scope.schedule })
				} else {
					console.error("Create freeze form is not valid")
				}
			}

			$scope.cancel = function () {
				$uibModalInstance.dismiss()
			}

			$scope.toggleSchedule = function () {
				if ($scope.shouldSchedule) {
					// Scheduling is turned on
					$scope.schedule.type = 'schedule'
					$scope.schedule.startDate = $scope.today()
					$scope.schedule.startTime = new Date(0, 0, 0, 0, 0, 0, 0)
					$scope.schedule.endDate = $scope.today()
					$scope.schedule.endDate.setDate($scope.today().getDate() + 1)
					$scope.schedule.endTime = new Date(0, 0, 0, 0, 0, 0, 0)

					$scope.schedule.expression = {}
					$scope.schedule.expression_type = ""
				} else {
					// Scheduling is turned off
					$scope.schedule.type = ""
					$scope.schedule.expression = ""
					$scope.schedule.expression_type = ""
				}
			}

			$scope.summary = ""

			$scope.set_summary = function () {
				var schedule = $scope.schedule

				// Clear summary
				$scope.summary = ""

				if (!schedule || !schedule.type) {
					return
				}

				var message = ""
				switch (schedule.expression_type) {
					case "weekly-repeat":
						// validate weekly repeat schedule
						if (!schedule.startDate || !schedule.endDate) {
							return message
						}

						message = freezes.printWeeklyRepeat(schedule.startDay, schedule.endDay, schedule.startTime, schedule.endTime)
				}

				if (message) {
					$scope.summary = "Summary: " + message
				}
			}
		}])
