app.controller('repo.status', ['$scope', '$stateParams', '$state', '$http', '$uibModal', 'config', 'deployments', 'repos', function ($scope, $stateParams, $state, $http, $uibModal, config, deployments, repos) {
    $scope.owner = $stateParams.owner
    $scope.repo = $stateParams.repo
    $scope.deployments = deployments
    $scope.ds = false
    $scope.selected_dc = "All"
    $scope.recent_deploy = false
    $scope.error_msg = false

    var init = function () {
        deployments.set_repo($scope.owner, $scope.repo)
        if ($stateParams.env != null) {
            $scope.selected_env = $stateParams.env
        } else {
            $scope.selected_env = deployments.environments[0]
        }
        update_deploystatus()
        update_recent_deploy()
    }

    var update_deploystatus = function () {
        $http.get(config.skadi_host + "/v1/deploystatus/" + $scope.owner + "/" + $scope.repo + "/" + $scope.selected_env)
            .success(function (r) {
                r.dcs = {"All": {"all": [], "mismatch": [], "selected": {}}}
                r["hosts"].sort(function (a, b) {
                    return (a.hostname > b.hostname) ? 1 : (a.hostname < b.hostname) ? -1 : 0
                })
                r["hosts"].forEach(function (h) {
                    if (h.datacenter === undefined) {
                        h.datacenter = "unknown"
                    }
                    if (r.dcs[h.datacenter] === undefined) {
                        r.dcs[h.datacenter] = {"all": [], "mismatch": [], "selected": {}}
                    }
                    r.dcs.All.all.push(h)
                    r.dcs[h.datacenter].all.push(h)
                    if (h.sha != r.deployed.sha) {
                        r.dcs.All.mismatch.push(h)
                        r.dcs.All.selected[h.hostname] = true
                        r.dcs[h.datacenter].mismatch.push(h)
                        r.dcs[h.datacenter].selected[h.hostname] = true
                    }
                })

                r.dcs_names = Object.keys(r.dcs)
                if (r["host-stat"]["total-hosts"] > 0) {
                    r.version_coverage = Math.round((100 * r["host-stat"]["hosts-match"] / r["host-stat"]["total-hosts"]) * 100) / 100
                    $scope.ds = r
                } else {
                    $scope.ds = false
                    $scope.error_msg = "No hosts deployed this version found (possibily not a courier-based deployment)"
                }
            })
            .error(function (e) {
                $scope.error_msg = e.VerboseError
            })
    }

    var update_recent_deploy = function () {
        deployments.get_deploys_for_env($scope.selected_env, 1).then(function (recent_deploys) {
            $scope.recent_deploy = recent_deploys.length > 0 ? recent_deploys[0] : false
        })
    }

    $scope.select_env = function () {
        $state.go('repo.status', {env: $scope.selected_env})
    }

    $scope.select_dc = function (dc) {
        $scope.selected_dc = dc
    }

    $scope.refresh = function () {
        update_deploystatus()
    }

    $scope.update_hostversion_info = function (ipaddr, status) {
        $http.get(config.skadi_host + "/v1/deploystatus/update/" + status + "/" + $scope.owner + "/" + $scope.repo + "/" + $scope.selected_env + "/" + ipaddr)
        .success(function (r) {
            $scope.refresh()
        })
    }

    $scope.redeploy = function (dc) {
        hosts = []
        Object.keys($scope.ds.dcs[dc].selected).forEach(function (k) {
            if ($scope.ds.dcs[dc].selected[k] == true) {
                hosts.push(k)
            }
        })
        if (hosts.length > 0) {
            $scope.selectredeploy(hosts)
        }
    }

    $scope.selectredeploy = function (hosts) {
        var modalInstance = $uibModal.open({
            templateUrl: 'templates/modal/selectredeploy.html',
            controller: 'selectredeploy_modal',
            resolve: {
                hosts: function () {
                    return hosts
                },
                desc: function () {
                    return "Redeploy " + $scope.ds.deployed.branch + "@" + $scope.ds.deployed.sha
                }
            }
        })

        modalInstance.result.then(function (settings) {
            deployments.set_environments($scope.owner, $scope.repo)
            return deployments.create($scope.ds.deployed.branch, $scope.ds.deployed.sha, $scope.selected_env, "desc", "", "", null, settings.hosts, 0)
        })
    }

    init()
}])

app.controller('selectredeploy_modal', ['$scope', '$uibModalInstance', 'hosts', 'desc', function ($scope, $uibModalInstance, hosts, desc) {
    $scope.hostsList = hosts
    $scope.hostsSelected = {}
    $scope.settings = {}
    $scope.settings.description = desc

    $scope.hostsList.forEach(function (k) {
        $scope.hostsSelected[k] = true
    })

    $scope.ok = function () {
        var hosts = []
        for (var name in $scope.hostsSelected) {
            if ($scope.hostsSelected[name]) {
                hosts.push(name)
            }
        }
        if (hosts.length > 0) {
            $scope.settings.hosts = hosts.join()
            $uibModalInstance.close($scope.settings)
        }
    }

    $scope.cancel = function () {
        $uibModalInstance.dismiss()
    }
}])
