app.service('artifacts', ['$q', '$http', '$cookies', 'config', 'repos', function($q, $http, $cookies, config, repos) {
	var that = this

	this.set_repo = function(owner, repo) {
		var deferred = $q.defer()

		that.owner = owner
		that.repo = repo
		that.deployed = []
		that.commits = {}
		that.is_loading = true

		that.load_deployed()
			.then(function() {
				that.is_loading = false
				deferred.resolve()
			})

		return deferred.promise
	}

	this.load_deployed = function() {
		var deferred = $q.defer()

		c = {
			params: {
				owner: that.owner,
				name: that.repo
			}
		}

		$http.get(config.skadi_host+"/v1/artifacts/deployed", c)
			.success(function(artifacts) {
				var envs = Object.keys(artifacts).sort()

				that.deployed = []
				envs.forEach(function(env) {
					that.deployed.push({
						env: env,
						artifact: artifacts[env]
					})
				})
				deferred.resolve(artifacts)
			})
			.error(function (data) {
				deferred.reject(data);
			})
		return deferred.promise
	}

	this.get_deployed_for_env = function(owner, repo, environment) {
		var deferred = $q.defer()

		c = {
			params: {
				owner: owner,
				name: repo,
				env: environment
			}
		}


		$http.get(config.skadi_host+"/v1/artifact/deployed", c)
			.success(function(artifact) {
				deferred.resolve(artifact)
			})
			.error(function (data) {
				deferred.reject(data);
			})
		return deferred.promise
	}

	this.get_comparison_for_env = function(owner, repo, environment, ref) {
		var deferred = $q.defer()

		c = {
			params: {
				owner: owner,
				name: repo,
				env: environment,
				ref: ref
			}
		}

		$http.get(config.skadi_host+"/v1/artifact/compare", c)
			.success(function(compare){
				deferred.resolve(compare)
			})
			.error(function (data) {
				deferred.reject(data);
			})
		return deferred.promise
	}
}]);
