app.service('candidates', ['$q', '$http', '$cookies', '$interval', 'config', 'users', function($q, $http, $cookies, $interval, config, users) {
    var that = this

    // get_current_user and current_user are kept for backwords compatibility.
    // any new references to users should use the users service
    this.get_current_user = function () {
        users.get_current_user().then(function (user) {
            that.current_user = user
        })
    }

    this.set_repo = function (owner, repo) {
        var deferred = $q.defer()

        if (that.current_interval != null) {
            $interval.cancel(that.current_interval)
        }

        that.owner = owner
        that.repo = repo
        that.current = []
        that.current_interval = null
        that.is_loading = true

        that.load_current()
            .then(function () {
                that.current_interval = $interval(that.load_current, 60000)
                that.is_loading = false
                deferred.resolve()
            })

        return deferred.promise
    }

    this.get_info = function () {
        var deferred = $q.defer()
        c = {
            params: {
                owner: that.owner,
                name: that.repo,
            }
        }
        $http.get(config.skadi_host + "/v1/candidate/info", c)
          .success(function (info) {
            that.repoinfo = info
  	  			deferred.resolve()
	  	  	})
        return deferred.promise
    }

    this.get_current = function() {
		  return that.current
	  }

    this.load_current = function() {
		var deferred = $q.defer()

		if (that.is_deploying) {
			deferred.resolve();
			return deferred.promise;
		}

		c = {
			params: {
				owner: that.owner,
				name: that.repo,
			}
		}

		$http.get(config.skadi_host+"/v1/candidate/current", c)
			.success(function(candidates) {
				that.current = candidates
				deferred.resolve()
			})

		return deferred.promise
	}

	this.get_candidate = function(branch) {
		var candidates = that.current
		var candidatesLength = candidates.length

		for (var i = 0; i < candidatesLength; i++) {
			var candidate = candidates[i]
			if (candidate.branch == branch) {
				return candidate
			}
		}
		return null
	}

	this.get_candidates = function() {
		return that.current
	}

	this.load_previous = function(branch) {
		var deferred = $q.defer()

		c = {
			params: {
				owner: that.owner,
				name: that.repo,
				branch: branch,
			}
		}
		$http.get(config.skadi_host+"/v1/candidate/previous", c)
			.success(function(candidates) {
				deferred.resolve(candidates)
			})

		return deferred.promise
	}

	this.state_classes = function(state) {
		classes = ["glyphicon", state]

		switch (state) {
			case "success":
				classes.push("glyphicon-ok")
				break
			case "pending":
				classes.push("glyphicon-time")
				break
			case "failure":
			case "error":
			case "aborted":
				classes.push("glyphicon-remove")
				break
			case "unknown":
				classes.push("glyphicon-question-sign")
				break
			case "rebuild":
				classes.push("glyphicon-hourglass")
				break
		}

		return classes
	}

	this.display_link_with_state = function(state) {
		var states_without_links = ["unknown", "rebuild"]
		// Any states besides states_without_links should display links
		return states_without_links.indexOf(state) == -1
	}

	this.previous_panel = ""
	this.previous_candidates = {}
	this.previous_loading = {}

	this.reset_candidates = function() {
		that.previous_panel = ""
		that.previous_candidates = {}
		that.previous_loading = {}
	}

	this.toggle_previous_candidates = function(branch) {
		if (that.previous_panel == branch) {
			that.previous_panel = ""
			that.previous_candidates[branch] = []
		} else {
			that.previous_panel = branch

			that.previous_loading[branch] = true
			that.load_previous(branch)
				.then(function(candidates) {
					that.previous_candidates[branch] = candidates
					that.previous_loading[branch] = false
				})
		}
	}

	this.rebuild = function(owner, name, ref) {
		var deferred = $q.defer()

		var c = {
			params: {
				owner: owner,
				name: name,
				ref: ref
			}
		}

		$http.post(config.skadi_host+"/v1/candidate/rebuild", undefined, c)
		  .success(function() {
			  deferred.resolve();
		  })
		  .error(function() {
			  deferred.reject();
		  });

		return deferred.promise;
	}

    this.notifycommit = function(owner, name, ref) {
        var deferred = $q.defer()

        var c = {
            params: {
                owner: owner,
                name: name,
                ref: ref
            }
        }

        $http.post(config.skadi_host+"/v1/candidate/notifycommit", undefined, c)
            .success(function() {
                deferred.resolve();
            })
            .error(function(data) {
                deferred.reject(data);
            });

        return deferred.promise;
    }
}]);
