app.service('freezes', ['$q', '$http', '$cookies', '$interval', 'config', 'repos', function($q, $http, $cookies, $interval, config, repos) {
    var that = this

    this.set_repo = function(owner, repo) {
        var deferred = $q.defer()

        if (that.current_interval != null) {
            $interval.cancel(that.current_interval)
        }

        that.owner = owner
        that.repo = repo
        that.has_frozen = false
        that.freezes = []
        that.current_interval = null
        that.is_loading = true

        that.load_freezes()
            .then(function() {
                that.is_loading = false
                that.current_interval = $interval(that.load_freezes, 30000)
                deferred.resolve()
            })

        return deferred.promise
    }

    this.load_freezes = function() {
        var deferred = $q.defer()

        c = {
            params: {
                repo: that.repo,
                owner: that.owner
            }
        }

        $http.get(config.skadi_host+"/v1/freeze/list", c).success(function(freezes){
            that.freezes = freezes
            that.has_frozen = freezes.reduce(function(x, y) {
                return x || y.is_frozen
            }, false)
            deferred.resolve()
        })

        return deferred.promise
    }

    var dayArray = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]

    this.printWeeklyRepeat = function(startDay, endDay, startTime, endTime) {
        var message = ""
        function printTime(date) {
            if (!date) {
                return message
            }

            var hour = date.getHours()

            var suffix = "AM"
            if (hour > 11) {
                suffix = "PM"
            }

            if (hour == 0) {
                hour = 12
            }

            var minutes = date.getMinutes()
            if (minutes < 10) {
                minutes = "0" + minutes
            }

            return hour + ":" + minutes + " " + suffix
        }

        message = "Repeats weekly from "
        message += dayArray[startDay]
        message += " at " + printTime(startTime)
        message += " to " + dayArray[endDay]
        message += " at " + printTime(endTime)
        return message
    }

    this.create = function(repo, owner, creator, reason, environment, schedule, autodeploy) {
        var data = {
            repo: repo,
            owner: owner,
            creator: creator,
            reason: reason,
            environment: environment,
            autodeploy: autodeploy
        }

        if (schedule && schedule.type) {
            data.type = schedule.type
            data.expression = schedule.expression
            data.expression_type = schedule.expression_type

            switch (schedule.expression_type) {
                case "weekly-repeat":
                    if (!data.expression) {
                        data.expression = {}
                    }
                    data.expression.start_day = parseInt(schedule.startDay)
                    data.expression.end_day = parseInt(schedule.endDay)
                    data.expression.start_time = schedule.startTime
                    data.expression.end_time = schedule.endTime
                    data.end_date = null
                    break
                default:
                    data.start_date = mergeDates(schedule.startDate, schedule.startTime)
                    data.end_date = mergeDates(schedule.endDate, schedule.endTime)
                    break
            }
        }

        $http.post(config.skadi_host+"/v1/freeze/create", JSON.stringify(data))
            .success(function(deployment) {
                that.set_repo(owner, repo)
            })
    }

    var mergeDates = function(date, time) {
        if (!date || !time) {
            return undefined
        }

        if (!(date instanceof Date)) {
            date = new Date(date)
        }
        if (!(time instanceof Date)) {
            time = new Date(time)
        }
        return new Date(date.getFullYear(), date.getMonth(), date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds())
    }

    this.delete = function(repo, owner) {
        var data = {
            repo: repo,
            owner: owner
        }

        $http.post(config.skadi_host+"/v1/freeze/delete", JSON.stringify(data))
            .success(function(data) {
                that.set_repo(owner, repo)
            })
    }

    this.unfreeze = function(f, current_user) {
        var data = {
            owner: f.owner,
            repo: f.repo,
            environment: f.environment,
            id: f.id,
            deleted_by: current_user,
            type: f.type
        }

        $http.post(config.skadi_host+"/v1/freeze/unfreeze", JSON.stringify(data))
            .success(function(data){
                that.set_repo(that.owner, that.repo)
            })
    }

    this.environment_frozen = function(environment_frozen) {
        var environmentLength = that.freezes.length
        if (environmentLength === 0) { return false }
        for (var i = 0; i < environmentLength; i++) {
            var freeze = that.freezes[i]
            if (freeze.environment === environment_frozen && freeze.is_frozen) { return freeze }
        }
        return false
    }
}]);
