app.service('org_settings', ['$q', '$http', 'config', function($q, $http, config) {
		var that = this

		this.getSubEmails = function(owner) {
				var deferred = $q.defer()
				c = {
						params: {
								org: owner
						}
				}

				$http.get(config.skadi_host+"/v1/subscriptions/", c).then(function(response){
					respData = response.data
					if (response.status == 200) {
						deferred.resolve(respData)
					} else {
						deferred.resolve()
					}
				})
			return deferred.promise
		}

		this.createSubscription = function(owner, email, success, pending, failure, environment) {
				var data = {
						org: owner,
						email: email,
						success: success,
						pending: pending,
						failure: failure,
						environment: environment
				}

				$http.post(config.skadi_host+"/v1/subscriptions/create", JSON.stringify(data))
						.then(function(response) {
								if (response.status == 200) {
									resp = response.data
									that.org_subscriptions = {}
									that.org_subscriptions.org = owner
									that.org_subscriptions.email = resp.email
									that.org_subscriptions.success = resp.success
									that.org_subscriptions.pending = resp.pending
									that.org_subscriptions.failure = resp.failure
									that.org_subscriptions.environment = resp.environment
								}
						})
		}

		this.deleteSubscription = function(owner, email, environment) {
				var data = {
						org: owner,
						email: email,
						environment: environment
				}

				$http.post(config.skadi_host+"/v1/subscriptions/delete", JSON.stringify(data))
		}

		this.updateSubscription = function(owner, email, success, pending, failure, environment) {
				var data = {
						org: owner,
						email: email,
						success: success,
						pending: pending,
						failure: failure,
						environment: environment
				}

				$http.post(config.skadi_host+"/v1/subscriptions/update", JSON.stringify(data))
		}
}]);
