app.service('repos', ['$window', '$q', '$http', '$cookies', 'config', function($window, $q, $http, $cookies, config) {
	this.loaded = false
	this.settings_exist = true
	this.by_org = {}
	this.settings = null
	this.warnings = ""
	this.deployJSON_invalid = ""
	this.fail_counter = 0
	var that = this

	this.load_my_repos = function() {
		var deferred = $q.defer()

		if (that.loaded) {
			deferred.resolve(that.by_org)
			return deferred.promise
		}

		that.by_org = {}

		c = {
			params: {
				per_page: 100
			}
		}

		$http.get(config.skadi_host+"/v1/user/repos", c)
			.success(function(data) {
				for (var i = 0; i < data.length; i++) {
					if (that.by_org[data[i].owner.login] == null) {
						that.by_org[data[i].owner.login] = []
					}
					that.by_org[data[i].owner.login].push(data[i])
				};

				// sort repos by pushed_at for each org
				for (var org in that.by_org) {
					that.by_org[org].sort(function(a, b) {
						date_a = new Date(a.pushed_at)
						date_b = new Date(b.pushed_at)

						if (date_a < date_b) {
							return 1
						} else if (date_b < date_a) {
							return -1
						} else {
							return 0
						}
					})
				}

				that.loaded = true
				deferred.resolve(that.by_org)
			})
			.error(function(data) {
				that.fail_counter++
				if (that.fail_counter > 2) {
					// looping has been detected, this is likely due to midway auth failure
					// one known route to this is that root page is being loaded from browser cache
					// and sub page of default router's resolver tries to hit the server and AEA return 403
					// letting the window reload will reisuue the AEA token.
					$window.location.reload(true)
				}
				deferred.reject(data)
			})

		return deferred.promise
	}

	this.load_settings = function(owner, name) {
		var deferred = $q.defer()

		$http.get(config.skadi_host+"/v1/repos/"+owner+"/"+name+"/settings")
		        .success(function(settings) {
                                if(settings.warnings != "") {
                                        that.warnings = settings.warnings
                                }
				if(settings.deploy.graphite_targets) {
				    var width = 640 / settings.deploy.graphite_targets.length;
				    settings.deploy.graphite_width = width;
				    var items = [];
				    for(var i=0; i<settings.deploy.graphite_targets.length; i++) {
					var url_params = "?width=" + width + "&height=100&bgcolor=white&fgcolor=darkgray&hideLegend=true&yMin=0&from=-2hours"
					    + "&target=" + settings.deploy.graphite_targets[i];
					var item = {url: "https://graphite.central.twitch.a2z.com/render" + url_params,
						    link_url: "https://graphite.central.twitch.a2z.com/" + url_params,
						    target: settings.deploy.graphite_targets[i]};
					items.push(item);
				    }
				    settings.deploy.graphite_items = items;
				}
				that.settings = settings
                that.deployJSON_invalid = ""
                that.settings_exist = true
				deferred.resolve(settings)
			})
                        .error(function(data) {
                                var error_message = 'Your deploy.json is invalid: ' + JSON.stringify(data)
                                console.error(error_message);
                                if (error_message.indexOf("404 Not Found") !== -1) {
                                    that.settings_exist = false
                                } else {
                                    that.deployJSON_invalid = error_message
                                }
                                deferred.resolve(null)
                        })

		return deferred.promise
	}
}]);

setInterval(function(){
    $('.graphite_chart').each(function(index) {$(this).attr('src', $(this).data('original-src')+"&cache-breaker=" + Math.random());});
}, 5000);
