app.service('users', ['$q', '$http', 'config', function($q, $http, config) {
	var that = this

	this.current_user = null

	this.get_current_user = function() {
		var deferred = $q.defer()

		if (that.current_user) {
			deferred.resolve(that.current_user)
			return deferred.promise
		}

		$http.get(config.skadi_host+"/v1/user")
			.success(function(user){
				that.current_user = user.login
				deferred.resolve(user.login)
			}).error(function(data) {
				console.error("Bad response in current_user: ", data)
				deferred.reject(data)
			})
		return deferred.promise
	}
}])
