-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE deployments (
   ID             serial PRIMARY KEY  NOT NULL,
   GithubID       int NOT NULL,
   Owner          VARCHAR(128),
   Repository     VARCHAR(128),
   SHA            CHAR(40),
   Branch         VARCHAR(128),
   Environment    VARCHAR(128),
   Creator        VARCHAR(128),

   CreatedAt      timestamp with time zone not null default current_timestamp,
   UpdatedAt      timestamp with time zone not null default current_timestamp,

   Status         VARCHAR(128)
);


-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE deployments;
