-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE freezeschedules (
    ID              serial PRIMARY KEY  NOT NULL,
    Owner           VARCHAR(128),
    Repository      VARCHAR(128),
    Creator         VARCHAR(128),
    Environment     VARCHAR(128),
    Reason          TEXT,
    CreatedAt       timestamp with time zone default current_timestamp,
    Deleted         BOOLEAN NOT NULL DEFAULT false,
    DeletedBy       VARCHAR(128),
    DeletedAt       timestamp with time zone,

    StartDate       timestamp with time zone,
    EndDate         timestamp with time zone,
    Expression      TEXT,
    ExpressionType  TEXT
);


-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE freezeschedules;
