-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE host_version (
  owner VARCHAR(128) NOT NULL,
  repository VARCHAR(128) NOT NULL,
  environment VARCHAR(128) NOT NULL,
  ipaddr VARCHAR(15) NOT NULL,
  sha VARCHAR(40) NOT NULL,
  deployedat timestamp NOT NULL,
  createdat timestamp NOT NULL DEFAULT current_timestamp,
  PRIMARY KEY(owner, repository, environment, ipaddr)
);

CREATE INDEX idx_host_version_ipaddr ON host_version(ipaddr);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP INDEX idx_host_version_ipaddr;
DROP TABLE host_version;
