-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE deployment_deploystatus (
  deployment_id  int references deployments(id),
  ipaddr   VARCHAR(15) NOT NULL,
  hostname VARCHAR(255) NOT NULL,
  sha      VARCHAR(40) NOT NULL DEFAULT '',
  phase    VARCHAR(32) NOT NULL DEFAULT '',
  status   VARCHAR(16) NOT NULL,
  detail   TEXT NOT NULL DEFAULT '',
  changedat timestamp NOT NULL DEFAULT current_timestamp,
  createdat timestamp NOT NULL DEFAULT current_timestamp
);

CREATE INDEX idx_deployment_deploystatus ON deployment_deploystatus(deployment_id, ipaddr, changedat);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP INDEX idx_deployment_deploystatus;
DROP TABLE deployment_deploystatus;
