# Skadi API

## Authentication

You authenticate to the skadi api by passing in a header containing a Github access token.

```
curl -H "GithubAccessToken: abc123" http://skadi.prod.us-west2.justin.tv/v1/user/repos
```

## Artifacts

### List deployed artifacts for each environment
### Download the artifact for a given environment

## Builds

- [Get build status for a commit](#get-build-status-for-a-commit)

### Get build status for a commit

```
GET /v1/build
```

**Parameters**

Name | Type | Description
-----|------|-------------
owner| string | Repository owner
name | string | Repository name
sha | string | Commit hash

**Response**

```json
{
	"duration":91945,
	"estimated_duration":104907,
	"percent":87
}
```

## Deployments

### Create deployment

```
POST /v1/deployments
```

**Input**

Name        | Type   | Description
------------|--------|--------------
ref         | string | The git ref to deploy
environment | string | The environment to deploy to
branch      | string | The Name of the branch the Ref is from, required for bookkeeping
description | string | A human description of what the purpose of the deploy is

**Response**

```json
{
    "branch": "master",
    "created_at": "2014-12-16T22:39:37Z",
    "creator": "tarrant",
    "environment": "staging",
    "github_id": 1169,
    "id": 54,
    "owner": "release",
    "repository": "test_repo",
    "sha": "6f95987735c7c8b101bcb9d9d2ef72921d8c313e"
}
```

### Get timing for active deploy
### List deployment history

```
GET /v1/deployments
```

**Parameters**

Name    | Type   | Default | Description
--------|--------|---------|------------
owner   | string | All     | Repository Owner
creator | string | All     | Creator of the Deploy Request
Repo    | string | All     | Repository Name
Branch  | string | All     | Name of Deployed Branch
Count   | int    | 10      | Number of Deploys to return, sorted by most recent

**Response**

```json
[
    {
        "branch": "hystrix-metrics",
        "created_at": "2014-12-16T22:24:43.182808Z",
        "creator": "kthornhill",
        "environment": "staging",
        "github_id": 1168,
        "id": 53,
        "owner": "release",
        "repository": "skadi",
        "sha": "81af88c49f231e84cc855b10a828d2cd7a6f7849",
        "updated_at": "2014-12-16T22:24:43.182808Z"
    },
    {
        "branch": "master",
        "created_at": "2014-12-16T22:03:34.254323Z",
        "creator": "kthornhill",
        "environment": "production",
        "github_id": 1167,
        "id": 52,
        "owner": "release",
        "repository": "skadi",
        "sha": "a218e15a38f16662a8f6e97785d65c802cc81fba",
        "updated_at": "2014-12-16T22:03:34.254323Z"
    }
]
```
### Single deployment
```
GET /v1/deployment/{id}
```

**Response**

```json
{
    "branch": "get_deployment",
    "created_at": "2001-10-13T12:12:41.182808Z",
    "creator": "steven",
    "environment": "staging",
    "github_id": 1170,
    "id": 8690,
    "owner": "release",
    "repository": "skadi",
    "sha": "81af88c49f231e84cc855b10a828d2cd7a6f7849",
    "updated_at": "2002-11-13T21:24:32.182808Z",
    "state": "success",
    "description": "add a new end point to get a single deployment"
}
```

## Update Status of a Deploy

Updates the status in various places including the database, consul, and
hipchat.

```
POST /v1/deployments/{id}/status
```

**Parameter**

Name | Type | Description
-----|------|--------------
id   | int  | The skadi id for the deploy

**Input**

Name  | Type   | Description
------|--------|--------------
state | string | The new state for the ID.

Valid options for state:

* `pending`
* `success`
* `error`
* `failure`

**Response**

```json
{
   "id": 51,
   "state": "error",
   "previous": "pending"
   "updated_at": "2014-12-16T22:24:43.182808Z"
}
```

## Get Status of a Deploy

```
GET /v1/deployments/{id}/status
```

**Response**

```json
{
   "id": 51,
   "state": "error",
   "previous": "pending"
   "updated_at": "2014-12-16T22:24:43.182808Z"
}
```

## Environments

- [List environments](#list-environments)
- [Get environment](#get-environment)

## List Environments

```
GET /v1/environments/
```

**Parameters**

Name     | Type | Description
---------|------|------------------------------------
per_page | int  | Number of results in page to return
page     | int  | Page offset

**Response**

```json
[
	{
		"name": "production"
	},
	{
		"name": "staging"
	},
	{
		"name": "dev"
	}
]
```

## Get Environment

```
GET /v1/environments/{name}
```

**Response**

```json
{
	"name": "production",
	"services": {
		"release/skadi": {
			"deployed": {
				"sha": "eb62e9ae1e102738ce9b9f81d159c5c3e33c9812",
				"branch": "master"
			},
			"rollback" :{
				"sha": "eb62e9ae1e102738ce9b9f81d159c5c3e33c9812",
				"branch": "master"
			}
		},
		"video/usher": {
			"deployed": {
				"sha": "558137c6d1a80caa9ef3c1411a640b9a1100dd1e",
				"branch": "master"
			},
			"rollback" :{
				"sha": "558137c6d1a80caa9ef3c1411a640b9a1100dd1e",
				"branch": "master"
			}
		},
		"web/web": {
			"deployed": {
				"sha": "45540d6ba083978d2dcc3965bcf379c4f915c1a9",
				"branch": "master"
			},
			"rollback" :{
				"sha": "45540d6ba083978d2dcc3965bcf379c4f915c1a9",
				"branch": "master"
			}
		}
	}
}
```

## Release Candidates

- [List current release candidates](#list-current-release-candidates)
- [List previous release candidates for a branch](#list-previous-release-candidates-for-a-branch)
- [Get build timing for pending release candidate](#get-build-timing-for-pending-release-candidate)

### List current release candidates

```
GET /v1/candidate/current
```

**Parameters**

Name | Type | Description
-----|------|-------------
owner| string | Repository owner
name | string | Repository name

**Response**

```json
[
	{
		"sha": "23f2a676c3256ad3027eb870c524e1f3ef27fe2d",
		"branch": "master",
		"date": "2014-11-26T21:42:18Z",
		"author": {
			"user": "kthornhill",
			"avatar_url": "https://gravatar.com/avatar/dbe60c715ade68222c6946b2e7405100?d=https%3A%2F%2Fidenticons.github.com%2Fa87ff679a2f3e71d9181a67b7542122c.png\u0026r=x",
			"html_url": "https://git.xarth.tv/kthornhill"
		},
		"state": "success",
		"target_url": "http://jenkins-master-0.prod.us-west2.justin.tv/job/release-skadi/84/console",
		"description": "Build #84 succeeded in 1 min 44 sec",
		"commit": {
			"author": {
				"date": "2014-11-26T21:42:18Z",
				"name": "Keith Thornhill",
				"email": "kthornhill@twitch.tv"
			},
			"committer": {
				"date": "2014-11-26T21:42:18Z",
				"name": "Keith Thornhill",
				"email": "kthornhill@twitch.tv"
			},
			"message": "remove unnecessary repo field from candidate",
			"tree": {
				"sha": "f03211a7a423d5cf1d6eec9973e67ce553a8b50b"
			},
			"url": "https://git.xarth.tv/api/v3/repos/release/skadi/git/commits/23f2a676c3256ad3027eb870c524e1f3ef27fe2d"
		}
	},
	{
		"sha": "0ada8f195e15dd0711e2c4a7ed60e1eeddf6d0dd",
		"branch": "new_deployment_api",
		"date": "2014-11-26T21:38:05Z",
		"author": {
			"user": "kthornhill",
			"avatar_url": "https://gravatar.com/avatar/dbe60c715ade68222c6946b2e7405100?d=https%3A%2F%2Fidenticons.github.com%2Fa87ff679a2f3e71d9181a67b7542122c.png\u0026r=x",
			"html_url": "https://git.xarth.tv/kthornhill"
		},
		"state": "success",
		"target_url": "http://jenkins-master-0.prod.us-west2.justin.tv/job/release-skadi/83/console",
		"description": "Build #83 succeeded in 1 min 45 sec",
		"commit": {
			"author": {
				"date": "2014-11-26T21:38:05Z",
				"name": "Keith Thornhill",
				"email": "kthornhill@twitch.tv"
			},
			"committer": {
				"date": "2014-11-26T21:38:05Z",
				"name": "Keith Thornhill",
				"email": "kthornhill@twitch.tv"
			},
			"message": "fix tests",
			"tree": {
				"sha": "3bf290023cd3a625dee6f4e77132259990c71273"
			},
			"url": "https://git.xarth.tv/api/v3/repos/release/skadi/git/commits/0ada8f195e15dd0711e2c4a7ed60e1eeddf6d0dd"
		}
	}
]
```

### List previous release candidates for a branch

```
GET /v1/candidate/previous
```

**Parameters**

Name | Type | Description
-----|------|-------------
owner| string | Repository owner
name | string | Repository name
branch | string | Branch name to list candidates from
page | int | Pagination
per_page | int | Pagination

**Response**

```json
[
  {
    "sha": "3f6b06a48b1251c4b2b1bf67422ee7484f944d55",
    "branch": "",
    "date": "2015-09-24T19:19:31Z",
    "author": {
      "login": "dnicklay",
      "avatar_url": "https://git.xarth.tv/avatars/u/196?",
      "html_url": "https://git.xarth.tv/dnicklay"
    },
    "state": "success",
    "target_url": "http://jenkins-master-0.prod.us-west2.justin.tv/job/release-skadi/658/",
    "description": "Build #658 succeeded in 38 sec",
    "commit": {
      "author": {
        "date": "2015-09-24T19:19:31Z",
        "name": "David Nicklay",
        "email": "david.nicklay@turner.com"
      },
      "committer": {
        "date": "2015-09-24T19:19:31Z",
        "name": "David Nicklay",
        "email": "david.nicklay@turner.com"
      },
      "message": "revert sha1 change",
      "tree": {
        "sha": "3b13d7b979f08f4462e7d90506f6963373ede3bc"
      },
      "url": "https://git.xarth.tv/api/v3/repos/release/skadi/git/commits/3f6b06a48b1251c4b2b1bf67422ee7484f944d55",
      "comment_count": 0
    }
  },
  ...
]

```

### Get build timing for pending release candidate

**TODO**

## Repositories

- [Create a deploy.json for a repo](#create-a-deploy.json-for-a-repo)
- [Get the Repo Settings](#get-the-repo-settings)
- [List all Repos](#list-all-Repos)

### Create a deploy.json for a repo

```
POST /v1/repos/{owner}/{name}/settings/default
```

This will create a `deploy.json` in the root of the repo with the contents of:

```json
{
	"room": "",
	"job": "",
	"environments": {
		"production": {}
	},
	"consul_services": [],
	"graphite_targets": [],
	"artifact": "tar",
	"restart": {
		"style": "fast"
	},
	"distribution": {
		"style": "fast"
	}
}
```

**Response**

```json
null
```

### Get the Repo Settings

```
GET /v1/repos/{owner}/{name}/settings
```

**Response**

```json
{
  "deploy": {
    "artifact": "tar",
    "job": "release-skadi-deploy",
    "consul_services": [
      "refresher",
      "skadi"
    ],
    "environments": {
      "clean-production": {
        "job": null,
        "subscriptions": {
          "dta@justin.tv": {
            "success": true,
            "failure": true,
            "pending": false
          }
        }
      },
      "clean-staging": {
        "job": null
      },
      "tarrant-1": {
        "job": null
      }
    },
    "room": "Release Engineering",
    "distribution": {
      "style": "fast"
    },
    "restart": {
      "style": "fast"
    },
    "graphite_targets": null
  },
  "warnings": "Error getting webhooks for \"release\": GET https://git.xarth.tv/api/v3/orgs/release/hooks: 404 Not Found []"
}
```

### List all Repos

```
GET /v1/repos
```

**Response**

```
{
  "Error": "error executing ListCommand",
  "VerboseError": "fallback failed with 'Not implemented yet.'. run error was 'Not implemented yet.'",
  "StatusCode": 500,
  "StatusMessage": "Internal Server Error"
}
```

## User

- [Get Current User](#get-current-user)
- [Get User's Repos](#get-users-repos)


### Get Current User

```
GET /v1/user
```

You must be logged in to access this page

**Response**

```json
{
  "login": "tarrant",
  "id": 3,
  "avatar_url": "https://git.xarth.tv/avatars/u/3?",
  "html_url": "https://git.xarth.tv/tarrant",
  "gravatar_id": "",
  "name": "Tarrant Rollins",
  "blog": "",
  "location": "SF",
  "email": "tarrant@twitch.tv",
  "hireable": false,
  "public_repos": 10,
  "public_gists": 3,
  "followers": 0,
  "following": 0,
  "created_at": "2015-03-07T05:37:08Z",
  "updated_at": "2015-09-24T23:15:54Z",
  "type": "User",
  "site_admin": true,
  "total_private_repos": 0,
  "owned_private_repos": 0,
  "private_gists": 11,
  "disk_usage": 824,
  "collaborators": 0,
  "url": "https://git.xarth.tv/api/v3/users/tarrant",
  "events_url": "https://git.xarth.tv/api/v3/users/tarrant/events{/privacy}",
  "following_url": "https://git.xarth.tv/api/v3/users/tarrant/following{/other_user}",
  "followers_url": "https://git.xarth.tv/api/v3/users/tarrant/followers",
  "gists_url": "https://git.xarth.tv/api/v3/users/tarrant/gists{/gist_id}",
  "organizations_url": "https://git.xarth.tv/api/v3/users/tarrant/orgs",
  "received_events_url": "https://git.xarth.tv/api/v3/users/tarrant/received_events",
  "repos_url": "https://git.xarth.tv/api/v3/users/tarrant/repos",
  "starred_url": "https://git.xarth.tv/api/v3/users/tarrant/starred{/owner}{/repo}",
  "subscriptions_url": "https://git.xarth.tv/api/v3/users/tarrant/subscriptions"
}

```

### Get User's Repos

```
GET /v1/user/repos
```

**Parameters**

Name | Type | Description
-----|------|-------------
per_page | int | Pagination (**required**)

**Response**

```json
[
  {
    "id": 8,
    "owner": {
      "login": "release",
      "id": 4,
      "avatar_url": "https://git.xarth.tv/avatars/u/4?",
      "html_url": "https://git.xarth.tv/release",
      "gravatar_id": "",
      "type": "Organization",
      "site_admin": false,
      "url": "https://git.xarth.tv/api/v3/users/release",
      "events_url": "https://git.xarth.tv/api/v3/users/release/events{/privacy}",
      "following_url": "https://git.xarth.tv/api/v3/users/release/following{/other_user}",
      "followers_url": "https://git.xarth.tv/api/v3/users/release/followers",
      "gists_url": "https://git.xarth.tv/api/v3/users/release/gists{/gist_id}",
      "organizations_url": "https://git.xarth.tv/api/v3/users/release/orgs",
      "received_events_url": "https://git.xarth.tv/api/v3/users/release/received_events",
      "repos_url": "https://git.xarth.tv/api/v3/users/release/repos",
      "starred_url": "https://git.xarth.tv/api/v3/users/release/starred{/owner}{/repo}",
      "subscriptions_url": "https://git.xarth.tv/api/v3/users/release/subscriptions"
    },
    "name": "manta-style",
    "full_name": "release/manta-style",
    "description": "Reproducible build system",
    "homepage": "https://code.justin.tv/release/manta-style",
    "default_branch": "master",
    "created_at": "2015-03-08T05:28:57Z",
    "pushed_at": "2015-09-23T17:59:59Z",
    "updated_at": "2015-08-11T23:11:16Z",
    "html_url": "https://git.xarth.tv/release/manta-style",
    "clone_url": "https://git.xarth.tv/release/manta-style.git",
    "git_url": "git://git.xarth.tv/release/manta-style.git",
    "ssh_url": "git@git.xarth.tv:release/manta-style.git",
    "svn_url": "https://git.xarth.tv/release/manta-style",
    "language": "Go",
    "fork": false,
    "forks_count": 3,
    "open_issues_count": 8,
    "stargazers_count": 0,
    "watchers_count": 0,
    "size": 799,
    "permissions": {
      "admin": true,
      "pull": true,
      "push": true
    },
    "private": false,
    "has_issues": true,
    "has_wiki": true,
    "has_downloads": true,
    "team_id": null,
    "url": "https://git.xarth.tv/api/v3/repos/release/manta-style",
    "archive_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/{archive_format}{/ref}",
    "assignees_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/assignees{/user}",
    "blobs_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/git/blobs{/sha}",
    "branches_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/branches{/branch}",
    "collaborators_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/collaborators{/collaborator}",
    "comments_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/comments{/number}",
    "commits_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/commits{/sha}",
    "compare_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/compare/{base}...{head}",
    "contents_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/contents/{+path}",
    "contributors_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/contributors",
    "downloads_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/downloads",
    "events_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/events",
    "forks_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/forks",
    "git_commits_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/git/commits{/sha}",
    "git_refs_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/git/refs{/sha}",
    "git_tags_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/git/tags{/sha}",
    "hooks_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/hooks",
    "issue_comment_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/issues/comments{/number}",
    "issue_events_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/issues/events{/number}",
    "issues_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/issues{/number}",
    "keys_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/keys{/key_id}",
    "labels_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/labels{/name}",
    "languages_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/languages",
    "merges_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/merges",
    "milestones_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/milestones{/number}",
    "notifications_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/notifications{?since,all,participating}",
    "pulls_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/pulls{/number}",
    "releases_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/releases{/id}",
    "stargazers_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/stargazers",
    "statuses_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/statuses/{sha}",
    "subscribers_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/subscribers",
    "subscription_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/subscription",
    "tags_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/tags",
    "trees_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/git/trees{/sha}",
    "teams_url": "https://git.xarth.tv/api/v3/repos/release/manta-style/teams"
  },
  ...
]
```

## Freeze

### Create a freeze

```
POST /v1/freeze/create
```

#### Body

```json
{
  "owner": "release",
  "repo": "skadi",
  "creator": "username",
  "reason": "why is the freeze being created?",
  "environment": "which environment should be frozen?"
}
```

#### Response

```
ok
```

### Create a scheduled freeze

```
POST /v1/freeze/create
```

Scheduled freezes have a type "schedule", start date, end date, expression type,
and expression. Start date and end date provide a way to start and end a freeze
in the future. If start date is excluded, the scheduled freeze starts now.
If end date is excluded, the scheduled freeze never ends. Expression and
expression type provide further fine grain schedule control such as only applying
the freeze to particular days and times of the week.

All times are expected to be formatted as `1899-12-31T08:00:00.000Z`.

Supported expressions:

`weekly-repeat`
Start and End days are ints where 0 is Sunday and 6 is Saturday.
Start and End times are javascript dates where only the time is used. The timezone is
assumed to be US/Pacific.

Example: Friday 12 AM to Monday 12 AM
```json
{
  "expression": "weekly-repeat",
  "expression_type": {
    "start_day": 5,
    "start_time": "1899-12-31T08:00:00.000Z",
    "end_day": 1,
    "end_time": "1899-12-31T08:00:00.000Z"
  }
}

```

All together:

```json
{
  "owner": "release",
  "repo": "skadi",
  "creator": "username",
  "reason": "why is the freeze being created?",
  "environment": "which environment should be frozen?",
  "type": "schedule",
  "expression": "weekly-repeat",
  "expression_type": {
    "start_day": 5,
    "start_time": "1899-12-31T08:00:00.000Z",
    "end_day": 1,
    "end_time": "1899-12-31T08:00:00.000Z"
  }
}
```

### Get a freeze

```
GET /v1/freeze/get
```

#### Parameters

Name | Type | Description
-----|------|-------------
owner | string | repository owner (**required**)
repo | string | repository name (**required**)

#### Response

```json
{
  "id": 2,
  "owner": "release",
  "repo": "skadi",
  "creator": "kevipike",
  "reason": "this is a test",
  "environment": "clean-staging",
  "deleted": false,
  "deleted_by": null,
  "deleted_at": null,
  "created_at": "2016-06-23T17:17:09.183411Z",
  "is_frozen": true,
  "expression_type": ""
}
```

### Get a scheduled freeze

```
GET /v1/freeze/get
```

#### Body

Name | Type | Description
-----|------|-------------
scheduled | bool | indicate this is a scheduled freeze (**required**)
id | int | id of scheduled freeze (**required**)

#### Response

```json
{
  "id": 12,
  "owner": "release",
  "repo": "skadi",
  "creator": "kevipike",
  "reason": "don't deploy on the weekend man, i've got plans",
  "environment": "clean-production",
  "deleted": false,
  "deleted_by": null,
  "deleted_at": null,
  "created_at": "2016-06-22T22:47:34.045964Z",
  "type": "schedule",
  "is_frozen": false,
  "start_date": "2016-06-22T12:00:00-07:00",
  "expression_type": "weekly-repeat",
  "expression": {
    "start_day": 5,
    "end_day": 1,
    "start_time": "1899-12-31T20:00:00.000Z",
    "end_time": "1899-12-31T17:00:00.000Z"
  }
}
```

### List freezes

```
GET /v1/freeze/list
```

Freezes and scheduled freezes are sent together.

#### Parameters

Name | Type | Description
-----|------|-------------
owner | string | repository owner (**required**)
repo | string | repository name (**required**)

#### Response

```json
[
  {
    "id": 2,
    "owner": "release",
    "repo": "skadi",
    "creator": "kevipike",
    "reason": "this is a test",
    "environment": "clean-staging",
    "deleted": false,
    "deleted_by": null,
    "deleted_at": null,
    "created_at": "2016-06-23T17:17:09.183411Z",
    "is_frozen": true,
    "expression_type": ""
  },
  {
    "id": 12,
    "owner": "release",
    "repo": "skadi",
    "creator": "kevipike",
    "reason": "don't deploy on the weekend man, i've got plans",
    "environment": "clean-production",
    "deleted": false,
    "deleted_by": null,
    "deleted_at": null,
    "created_at": "2016-06-22T22:47:34.045964Z",
    "type": "schedule",
    "is_frozen": false,
    "start_date": "2016-06-22T12:00:00-07:00",
    "expression_type": "weekly-repeat",
    "expression": {
      "start_day": 5,
      "end_day": 1,
      "start_time": "1899-12-31T20:00:00.000Z",
      "end_time": "1899-12-31T17:00:00.000Z"
    }
  }
]
```

### Unfreeze freeze

```
POST /v1/freeze/unfreeze
```

#### Body

```json
{
  "id": 1,
  "deleted_by": "kevipike"
}
```

#### Response

```
ok
```

### Unfreeze scheduled freeze

```
POST /v1/freeze/unfreeze
```

#### Body

```json
{
  "id": 1,
  "type": "scheduled",
  "deleted_by": "kevipike"
}
```

#### Response

```
ok
```

## OAUTH

The OAUTH endpoints are internal only and should not be used outside of the
deploy frontend.


## Debugging and Internal Counter

Skadi has internal counters for debugging purpose and can be accessed via API.

### List of counter groups

```
GET /info
```

```json
{
  "info": [
    "all",
    "deployfactory",
    "deployqueue",
    "deploystatus",
    "deploytarget",
    (...omitted...)
  ]
}
```

Counters are grouped and stored under group target. `/info` API lists the name of groups

### Getting the counter detail

```
GET /info/${target}
ex) GET /info/deploystatus
```

```json
{
  "Running": 1,
  "Jobs": [
    {
      "Target": "release/example/test",
      "State": "setup",
      "StartTime": "2016-08-19 22:17:42.788664849 +0000 UTC",
      "Runtime": 3
    }
  ]
}
```

Note that:
* `/info/all` is a special target that shows everything except of `memstats`
* The json output is pretty formatted for human read.
* Counters shows when it's triggered, so at the start of Skadi it won't show all the counters but it'll show more as it goes. Some of error counters could never appears if they never get to happen.

### For programming interface

```
GET /debug/vars
```

This target prints everything includes memstats without pretty format and can be used for programming interface purpose.

