# Customizing Slack Messages

Using the `slack.json` file in the root of your repository, you can filter which messages get sent to your team's channel. By default, build success and failure messages are sent for the master branch and deploy success and failure messages are sent for all environments.

Use the following examples to choose how your team's channel is notified. Using `*` matches all branches/environments.

### Use the defaults

```json
{ "channel": "#foo" }
```

### Notify deployment creator when deployment is complete
```json
{ "notify_deploy_user": true }
```

### Critical failures only

```json
{
	"channel": "#foo",
	"build": {
		"branches": {
			"master": {
				"pending": false,
				"success": false,
				"failure": true
			}
		}
	},
	"deploy": {
		"environments": {
			"production": {
				"pending": false,
				"success": false,
				"failure": true
			}
		}
	}
}
```

### Maximum verbosity

```json
{
	"channel": "#foo",
	"build": {
		"branches": {
			"*": {
				"pending": true,
				"success": true,
				"failure": true
			}
		}
	},
	"deploy": {
		"environments": {
			"*": {
				"pending": true,
				"success": true,
				"failure": true
			}
		}
	}
}
```