# Service Dashboard
  * CloudWatch Dashboard - https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#dashboards:name=Skadi
  
# Service Info
  * `prod` environment
    * URL: http://deploy.xarth.tv/
    * Runtime Config Check: https://deploy.xarth.tv/info/config
    * CloudWatch Logs: https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=/twitch/dta/skadi;streamFilter=typeLogStreamPrefix
    * Config Update: https://us-west-2.console.aws.amazon.com/systems-manager/parameters?region=us-west-2 
  * `staging` environment
    * URL: http://deploy-dev.xarth.tv/
    * Runtime Config Check: https://deploy-dev.xarth.tv/info/config
    * Config Update: https://us-west-2.console.aws.amazon.com/systems-manager/parameters?region=us-west-2

NOTES)
  * All the environments (except for datacenter k/v)are in `ssm-paramstore` inside of AWS Systems Manager in the `twitch-core-services` AWS account 
  and is located [here][1]
  * *NOTE:* If you are attempting to update the datacenter list for skadi deployments, this K/V pair is stored in consul and managed by video team.

# Emergency rollback
If skadi goes down due to bad deployment and can't use skadi UI to roll itself back.
  * Update this symlink `/opt/twitch/skadi/current` to desired previous version `/opt/twitch/skadi/releases/$VERSION`
  * Restart `svc -du /etc/service/skadi`

# How to update configuration
Skadi uses ssmforerunner for the configuration which pulls configuration from the AWS ssm-paramstore.
To update the configuration, visit the [AWS UI][1], locate the parameter you want to change, and click on the parameter 
and then click `edit`, and then edit the `Value`

For an example, the config link to clean-production is [here][1] Then bounce the instance to apply the new config by either a deployment or svc command.
 
  * Bouncing one instance to confirm
    * `tail -f /var/log/jtv/skadi.log &`
       (run this in background or in a different terminal to catch any startup errors immediately)
    * `sudo svc -du /etc/service/skadi`
    * Verify the new configuration is loaded at https://deploy.xarth.tv/info/config
  * Bouncing the service
    * Currently there's only 1 instance running for clean-production
    * Beta and Prod(pre-prod) have 2 instances each.
    * To bounce the entire instances
      * Visit `https://deploy.xarth.tv/#/dta/skadi/history?env=clean-production`
      * Click `redeploy` on the latest & currently running version
      
*NOTE:* 
* Since some services external to devtools still use Consul to determine a datacenter list, 
you still have to vist the consul UI and update the datacenter list there as well. (links are under `prod-consul`)
* Skadi uses a special version of forerunner (called ssmforerunner, which uses ssmlibforerunner) to load its config from both SSM and Consul
    * Information regarding [ssmforerunner][4] and [ssmlibforerunner][5]
 

# How-to

## How to check skadi's runtime status
Skadi has integrated debug statistics
  * http://deploy.xarth.tv/info will show all the statistics categories.
  * http://deploy.xarth.tv/info/$CATEGORY_NAME will show the statistics under that category
    (Some categories created by 3rd party libraries will show up here but we don't map it, so in order to see them,
     use `/info/all`)
  * http://deploy.xarth.tv/info/all will show most of statistics in interests

## Where the log files?
  * /var/log/jtv/
    * skadi.json.log - application log
    * skadi.log - web access log

# Other documentation

- [dta/docs][3]
- [twitch/docs/release][2]

[1]: https://us-west-2.console.aws.amazon.com/systems-manager/parameters?region=us-west-2
[2]: https://git.xarth.tv/twitch/docs/blob/master/release/deploy.md
[3]: https://git.xarth.tv/dta/docs/blob/master/skadi.md
[4]: https://git.xarth.tv/dta/ssmforerunner
[5]: https://git.xarth.tv/dta/ssmlibforerunner
