Configuring a repository
===

Configuration for a repository is read from `deploy.json` in your GitHub Enterprise repository. The configuration file is read from the SHA you are deploying. The configuration file format is a json object with the fields detailed below.

Example deploy.json
---

```
{
    "artifact": "tar",
    "job": "dta-skadi-deploy",
    "consul_services": [
        "skadi"
    ],
    "datacenters": ["devtools", "us-west2"]
    "environments": {
        "clean-production": {
            "job": "dta-skadi-deploy-production",
            "subscriptions": {
                "dta@justin.tv": {"success": true, "pending": false, "failure": true}
            },
            "whitelist": ["master"],
            "required_contexts": ["dta-skadi"]
        },
        "package-testing": {
            "artifact": "pkg"
        }
    },
    "distribution": {
        "style": "gradual",
        "concurrency": 1,
        "fail_threshold": 3.5,
        "fail_threshold_type": "percent"
    },
    "restart": {
        "style": "gradual",
        "concurrency": 1
        "fail_threshold": 1,
        "fail_threshold_type": "number"
    },
    "slack": {
        "channel": "#dta-notifications",
        "build": {
            "branches": {
                "master": {
                    "success": false,
                    "failure": true,
                    "pending": false
                }
            }
        },
        "deploy": {
            "environments": {
                "clean-production": {
                    "success": true,
                    "failure": true,
                    "pending": true
                }
            }
        },
        "coverage": {
            "branches": {
                "master": {
                    "success": true,
                    "failure": true,
                    "pending": true
                }
            }
        }
    }
    "build_status_context": "dta-skadi"
}
```

Config Fields
---

* #### `artifact` - string

    Type of artifact to deploy. Valid options are `"tar"`, `"pkg"`.

    `"tar"` artifacts are .tar.gz files downloaded from S3 and extracted to the local filesystem. Services are then restarted according to the `restart` configuration object.

    `"pkg"` artifacts are .deb or .rpm files installed via apt or yum (depending on host platform). Services are responsible for restarting themselves in post-install scripts - see [Courier documentation](https://git.xarth.tv/release/courier/tree/master/doc/states.md#pkg-local-install)

* #### `job` - string

    The Jenkins job to trigger when running the deployment.

* #### `consul_services` - string[]

    A list of services in the consul catalog. When searching for deployment target hosts, a node will be considered a match if it has any service (and the service has a tag matching the environment, see [`environments`](#environments---environmentconfigstring)) in this list.

* #### `datacenters` - string[] _(optional)_ 

    A list of consul datacenters. Only these datacenters will be searched when finding deployment target hosts. If not specified, this will default to every production datacenter.

* #### `environments` - [EnvironmentConfig](#environmentconfig-fields)[string]

    A map of environment names to environment configuration objects. When searching for deployment target hosts, a node will only be added as a target if its matching service is tagged with the environment name.

* #### `distribution` - [DistributionConfig](#distributionconfig-fields) _(optional)_

    An object that configures how the artifact is distributed.

* #### `restart` - [RestartConfig](#restartconfig-Fields) _(optional)_

    An object that configures how the service is restarted.

* #### `docker` - [DockerConfig](#dockerconfig-fields) _(optional)_

    An object that configures the docker artifact and service.

* #### `slack` - [SlackConfig](#slackconfig-fields) _(optional)_

    An object that configures how notifications are sent in Slack.

* #### `smoca` [SmocaConfig](#smocaconfig-fields) _(optional)_

    An object that configures Smoca downstream job integration.

* #### `build_status_context` - string _(optional)_

    The [context](https://developer.github.com/v3/repos/statuses/) of a commit status to evaluate when considering if a commit can be deployed. If not set, all contexts are evaluated.

    This config is deprecated and will be removed in the next major release. Use `required_contexts` instead.

    See [Build statuses](#build-statuses) for more details on this setting.

* #### `required_contexts` - string[] _(optional)_

    Allows you to specify a subset of contexts that must be "success", or to specify contexts that have not yet been submitted. If you do not require any contexts or create any commit statuses, the deployment will always succeed.

    This configuration is global for all environments. If it's not set, it will fall back to `build_status_context`.

    See [Build statuses](#build-statuses) for more details on this setting.

### EnvironmentConfig Fields

* #### `environments.<environment>.job` - string _(optional)_

    The jenkins job to trigger for this environment, overriding the [`job`](#job---string) specified in the root config.

* #### `environments.<environment>.subscriptions` - [EnvironmentSubscription](#environmentsubscription-fields)[string] _(optional)_

    A map of email addresses to subscription configuration objects. When a deployment status is updated, a notification is sent to each email address in this field.

* #### `environments.<environment>.whitelist` - string[] _(optional)_

    A list of branches. Only these branches will be allowed to deploy to this environment.

* #### `environments.<environment>.required_contexts` - string[] _(optional)_

    Allows you to specify a subset of contexts that must be "success", or to specify contexts that have not yet been submitted. If you do not require any contexts or create any commit statuses, the deployment will always succeed.

    If a `required_contexts` config for a given environment is not given, Skadi will fall back to the global `required_contexts`.

    See [Build statuses](#build-statuses) for more details on this setting.

* #### `environments.<environment>.awsaccountid` - string _(optional)_

    An AWS account id. This is used in CodeDeploy deployments that use [mekansm](https://git.xarth.tv/dta/mekansm) to designate the AWS account to use for CodeDeploy deployments.

* #### `environments.<environment>.artifact` - string _(optional)_

    Type of artifact to deploy for this environment, overriding the [`artifact`](#artifact---string) specified in the root config.

### EnvironmentSubscription Fields

* #### `environments.<environment>.subscriptions.<subscription>.success` - boolean _(optional)_

  If this is set to true, then an email will be sent to the subscription email address when a deployment succeeds.

* #### `environments.<environment>.subscriptions.<subscription>.failure` - boolean _(optional)_

    If this is set to true, then an email will be sent to the subscription email address when a deployment fails.

* #### `environments.<environment>.subscriptions.<subscription>.pending` - boolean _(optional)_

    If this is set to true, then an email will be sent to the subscription email address when a deployment begins.

### DistributionConfig Fields

* #### `distribution.style` - string

    Execution style of artifact distribution. Valid options are `"fast"` and `"gradual"`. Defaults to `"fast"`.

    `"fast"` executes on all hosts at once.

    `"gradual"` executes on a limited number of hosts at a time, set by [`distribution.concurrency`](#distributionconcurrency---number-required-if-distributionstyle-is-gradual).

* #### `distribution.concurrency` - number _(required if [`distribution.style`](#distributionstyle---string) is `"gradual"`)_

    The limit of simultaneous hosts executing distribution.

* #### `distribution.fail_threshold` - float32

    If this is set to greater than 0, deployment will continue and be marked successful until the distribution failure reached this value.

* #### `distribution.fail_threshold_type` - string

    Set to "number" or "percent" to specify whether fail_threshold value is number of failures or percentage of failure. The default is "number" if not specified.

### RestartConfig Fields

* #### `restart.style` - string _(optional)_

    Execution style of service restart. Valid options are `"fast"` and `"gradual"`. Defaults to `"fast"`.

    `"fast"` executes on all hosts at once.

    `"gradual"` executes on a limited number of hosts at a time, set by [`restart.concurrency`](#restartconcurrency---number-required-if-restartstyle-is-gradual).

* #### `restart.concurrency` - number _(required if [`restart.style`](#restartstyle---string) is `"gradual"`)_

    The limit of simultaneous hosts executing restart.

* #### `restart.fail_threshold` - float32

    If this is set to greater than 0, deployment will fail when the number/percentage of restart failure reached this value.

* #### `restart.fail_threshold_type` - string

    Set to "number" or "percent" to specify whether fail_threshold value is number of failures or percentage of failure. The default is "number" if not specified. Note that, the failed hosts in distribution phase do not count as they are excluded from restart.

* #### `restart.service` - string _(optional, only valid when [`artifact`](#artifact---string) is `"tar"`)_

    When this is defined, courier will restart a daemontools service with this name. If this is undefined, courier will default to restarting the service by running `courier/restart.sh` or `courier/restart.sh` in the current installation directory.

* #### `restart.signal` - string _(optional, only valid when [`restart.service`](#restartstyle---string) is defined)_

    The flag to pass to [`svc`](https://cr.yp.to/daemontools/svc.html) when restarting the service. Defaults to `"-i"`, an INT signal.

* #### `restart.wait` - number _(optional, only valid when [`restart.service`](#restartstyle---string) is defined)_

    The time in seconds to wait for the daemontools service to finish restarting. Defaults to 10 seconds.

* #### `restart.uptime` - number _(optional, only valid when [`restart.service`](#restartstyle---string) is defined)_

    The time in seconds the service needs to be up after `restart.wait`. Defaults to half of `restart.wait`.

### DockerConfig Fields

* #### `docker.image` - string

    The repository of the docker image name (i.e. images names have two parts, repository:tag) when pulling when distributing the artifact. The SHA of the artifact will be appended as the tag of the image name.

* #### `docker.flags` - string _(optional)_

    Additional flags to pass to the `docker` command when restarting the service on hosts.

### Slack Fields

* #### `slack.channel` - string

    The channel where notifications are sent.

* #### `slack.build` [SlackBuildConfig](#slackbuildconfig-fields) _(optional)_

    An object that configures slack notifications about builds.

* #### `slack.deploy` [SlackDeployConfig](#slackdeploy-fields) _(optional)_

    An object that configures slack notifications about deployments.

* #### `slack.coverage` [SlackCoverageConfig](#slackcoverageconfig-fields) _(optional)_

    An object that configures slack notifications about coverage reports.

### SlackBuildConfig Fields

* #### `slack.build.branches` [SlackBuildBranchSubscription](#slackbuildbranchsubscription-fields)[string] _(optional)_

    A map of branches to subscription configuration objects. When a commit status is updated, a notification is sent to the slack channel.

### SlackBuildBranchSubscription Fields

* #### `slack.build.branches.<branch>.success` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked successful.

* #### `slack.build.branches.<branch>.failure` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked failure.

* #### `slack.build.branches.<branch>.pending` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked pending.

### SlackDeployConfig Fields

* #### `slack.deploy.environments` [SlackDeployEnvironmentSubscription](#slackdeployenvironmentsubscription-fields)[string] _(optional)_

    A map of environments to subscription configuration objects. When a deployment is updated, a notification is sent to the slack channel.

### SlackDeployEnvironmentSubscription Fields

* #### `slack.deploy.environments.<environment>.success` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a deployment succeeds.

* #### `slack.deploy.environments.<environment>.failure` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a deployment fails.

* #### `slack.deploy.environments.<environment>.pending` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a deployment begins.

### SlackCoverageConfig Fields

* #### `slack.coverage.branches` [SlackCoverageBranchSubscription](#slackcoveragebranchsubscription-fields)[string] _(optional)_

    A map of branches to subscription configuration objects. When a commit status is updated, a notification is sent to the slack channel.

### SlackCoverageBranchSubscription Fields

* #### `slack.coverage.branches.<branch>.success` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked successful.

* #### `slack.coverage.branches.<branch>.failure` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked failure.

* #### `slack.coverage.branches.<branch>.pending` - boolean _(optional)_

    If this is set to true, then a message will be sent to the slack channel when a commit status on the branch is marked pending.

### SmocaConfig Fields

* #### `smoca.hidden` - boolean _(optional)_

    If this is set to true, Smoca is always triggered after a deployment.

* #### `smoca.opt_out` - boolean _(optional)_

    If this is set to true, the UI checkbox to enable triggering Smoca is enabled by default.


Build statuses
---

There are several way to define if a deployment is succesful or not depending on it's [contexts](https://developer.github.com/v3/repos/statuses/). See:

- [build_status_context](#build_status_context---string-optional)
- [global required contexts](#required_contexts---string-optional)
- [environment required contexts](#environmentsenvironmentrequired_contexts---string-optional)

If nothing is defined in the configuration, then all contexts must be succesful (✅) for the deployment to continue. If there are more than one commit statuses and one or more fail (❌), then the deployment will fail.

The legacy `build_status_context` config can be used to define at least one commit status that must be successful for the deployment to work. If the context defined in this setting is successful (✅), then the deployment will continue even if the other contexts fail. At the same time, if the context defined in this setting fails (❌), then the deployment will fail even if other contexts are succesful.

The `required_contexts` config appears in both a global and environment scope. In both cases, the behavior is the same. All contexts defined in this setting must be successful for the deployment to continue.

Let's say we have a `required_contexts` value of `["skadi", "skadi-pr"]`. If both contexts are succesful (✅), then the deployment will continue even if another context called `"skadi-coverage"` fails. At the same time, if either `skadi` or `skadi-pr` fail (❌), then the deployment will fail.

If `required_contexts` is defined as an empty list, then the contexts are ignored and the deployment will always continue.
