# Using the site tester

## Installing and running the tester

```
pip install pytest
cd util/site-tester
py.test --ghe-token=<github enterprise token> [--base-url=<skadi base URL>] [--skip-create]
```

### Parameters

--ghe-token (required) The GitHub Enterprise API token to pass to skadi. You can find your token in the headers sent to skadi from the browser or you can create a new token from <github base URL>/settings/applications

--base-url Hostname of skadi to test against. Defaults to `http://localhost:8080`

--skip-create Skip tests against endpoints that create new database rows

## Developing the tester

Tests go in `test-site.py`, py.test looks for source files matching `test-*.py` and `*-test.py`.

### Adding a new test

Here's a basic test:

```
def test_get_deployed_basic(base_url, ghe_token):
r = requests.get("{0}/v1/basic".format(base_url),
  params={"query1": "foo"}, # query string parameters
  headers={"GithubAccessToken": ghe_token}, # github token header
  cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"}) # github token cookie
print r.text # print the response contents to stdout on test fail
j = r.json()
assert "Error" not in j

```

Add it to test-site.py, and it will run as part of the suite.

### Adding a new command-line parameter

Command-line parameters are configured in `conftest.py`. Adding a command-line parameter is done by adding it in the `pytest_addoption` hook.

```
def pytest_addoption(parser):
    parser.addoption("--base-url", action="store",
        help="base url for tests", type="string", dest="base_url", default="http://localhost:8080")
```

Information on the addoption method can be found in the [optparse documentation](https://docs.python.org/2/library/optparse.html#defining-options)

A command-line parameter can be turned into a fixture that can be used as parameters to test functions. Adding a fixture is done by adding it in the `pytest_generate_tests` hook.

```
def pytest_generate_tests(metafunc):
    if 'base_url' in metafunc.fixturenames:
        metafunc.parametrize('base_url', [metafunc.config.option.base_url])
```

### Supported fixtures

`base_url` is a string of the base URL of skadi

`ghe_token` is a string token for github enterprise api calls
