package testhelper

import (
	"io/ioutil"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/dta/skadi/pkg/config"
)

// CORSTester checks that an endpoint correctly has CORS headers set.
func CORSTester(t *testing.T, handler http.Handler, urls ...string) {
	server := httptest.NewServer(handler)
	defer server.Close()

	for _, url := range urls {
		req, err := http.NewRequest("OPTIONS", server.URL+url, nil)
		if err != nil {
			t.Fatalf("Unable to build HTTP request for %q: %v", url, err)
		}

		resp, err := http.DefaultClient.Do(req)
		if err != nil {
			t.Fatalf("Unable to make HTTP request for %q: %v", url, err)
		}
		defer resp.Body.Close()

		body, err := ioutil.ReadAll(resp.Body)
		if err != nil {
			t.Fatalf("Error reading body of request for %q: %v", url, err)
		}

		if resp.StatusCode != http.StatusOK {
			t.Fatalf("Received %d; expected 200 for %q; err: %q", resp.StatusCode, url, body)
		}

		if resp.Header.Get(config.AccessControlOrigin) == "" {
			t.Errorf("Header not set for %q: %s", url, config.AccessControlOrigin)
		}

		if resp.Header.Get(config.AccessControlHeaders) == "" {
			t.Errorf("Header not set for %q: %s", url, config.AccessControlHeaders)
		}
	}
}
